/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.util;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityUtil {
    public static Vec3 getRelativePosition(LivingEntity entity, double leftOffset, double upOffset, double backwardOffset) {
        Vec3 forward = EntityUtil.getBodyForward(entity);
        Vec3 left = new Vec3(forward.z, 0.0, -forward.x).normalize();
        AABB bounds = entity.getBoundingBox();
        Vec3 base = new Vec3((bounds.minX + bounds.maxX) / 2.0, bounds.minY, (bounds.minZ + bounds.maxZ) / 2.0);
        return base.add(forward.scale(-backwardOffset)).add(left.scale(leftOffset)).add(0.0, upOffset, 0.0);
    }

    public static Vec3 getBodyForward(LivingEntity entity) {
        float yawRad = entity.yBodyRot * ((float)Math.PI / 180);
        return new Vec3((double)(-Mth.sin((float)yawRad)), 0.0, (double)Mth.cos((float)yawRad)).normalize();
    }

    public static boolean canMobSeeBlock(Mob mob, Vec3 targetVec) {
        Vec3 eyePos;
        ClipContext context;
        Level level = mob.level();
        BlockHitResult hitResult = level.clip(context = new ClipContext(eyePos = mob.getEyePosition(), targetVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)mob));
        return hitResult.getType() == HitResult.Type.MISS || hitResult.getLocation().distanceToSqr(targetVec) < 0.1;
    }
}

