/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.util;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3fc;

public class MovementAnalyzer {
    private final Entity entity;
    private final Vector3d deltaPosition;
    private final Vector3d lastPosition;
    private int lastTick;

    public MovementAnalyzer(Entity entity) {
        this.entity = entity;
        this.lastPosition = new Vector3d((Vector3fc)entity.position().toVector3f());
        this.deltaPosition = new Vector3d();
    }

    public void tick() {
        if (this.entity.tickCount == this.lastTick) {
            return;
        }
        Vector3d prevPos = this.lastPosition;
        double prevPosX = prevPos.x;
        double prevPosY = prevPos.y;
        double prevPosZ = prevPos.z;
        Vec3 pos = this.entity.position();
        double posX = pos.x;
        double posY = pos.y;
        double posZ = pos.z;
        this.deltaPosition.set(posX - prevPosX, posY - prevPosY, posZ - prevPosZ);
        this.lastPosition.set(pos.x, pos.y, pos.z);
        this.lastTick = this.entity.tickCount;
    }

    public boolean isMovingHorizontally() {
        return this.deltaPosition.x != 0.0 || this.deltaPosition.z != 0.0;
    }

    public boolean isMovingVertically() {
        return this.deltaPosition.y != 0.0;
    }

    public boolean isMoving() {
        return this.isMovingHorizontally() || this.isMovingVertically();
    }
}

