/*
 * Decompiled with CFR 0.152.
 */
package com.avp.mixin;

import com.avp.common.registry.init.item.AVPItems;
import com.human.common.gameplay.item.canister.CanisterItem;
import com.human.common.registry.init.HumanDataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Cow.class})
public abstract class MixinCow_FillMilkCanister
extends Animal {
    protected MixinCow_FillMilkCanister(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void mobInteractMixin(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack updatedStack;
        ItemStack itemStack = player.getItemInHand(hand);
        if (this.isBaby() || !MixinCow_FillMilkCanister.isMilkHoldingCanister(itemStack)) {
            return;
        }
        int contentAmount = (Integer)itemStack.getOrDefault(HumanDataComponents.CANISTER_CAPACITY.get(), (Object)0);
        if (contentAmount == 0) {
            updatedStack = ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)AVPItems.MILK_CANISTER.get().getDefaultInstance());
        } else if (contentAmount < 8) {
            updatedStack = CanisterItem.updateCapacity((LivingEntity)player, itemStack, 1);
        } else {
            cir.setReturnValue((Object)InteractionResult.PASS);
            return;
        }
        player.playSound(SoundEvents.COW_MILK, 1.0f, 1.0f);
        player.setItemInHand(hand, updatedStack);
        cir.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)this.level().isClientSide));
    }

    @Unique
    private static boolean isMilkHoldingCanister(ItemStack itemStack) {
        return itemStack.is(AVPItems.CANISTER.get()) || itemStack.is(AVPItems.MILK_CANISTER.get());
    }
}

