/*
 * Decompiled with CFR 0.152.
 */
package com.avp.mixin;

import com.avp.common.gameplay.effect.RadiationStatusEffect;
import com.avp.common.registry.init.AVPMobEffects;
import com.avp.common.registry.key.AVPBiomeKeys;
import com.avp.common.util.AVPPredicates;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity_NukedRadiation
extends Entity {
    public MixinLivingEntity_NukedRadiation(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void tick(CallbackInfo callbackInfo) {
        LivingEntity self = (LivingEntity)LivingEntity.class.cast((Object)this);
        if (!AVPPredicates.canBeIrradiated((Entity)self)) {
            return;
        }
        if (!this.isIsEntityInAnIrradiatedBiome(self)) {
            return;
        }
        self.addEffect(new MobEffectInstance(AVPMobEffects.RADIATION.getHolder(), RadiationStatusEffect.EFFECT_DURATION_IN_TICKS, 0));
    }

    @Unique
    private boolean isIsEntityInAnIrradiatedBiome(LivingEntity self) {
        return self.level().getBiome(self.blockPosition()).is(AVPBiomeKeys.NUKED_BIOME);
    }
}

