/*
 * Decompiled with CFR 0.152.
 */
package com.avp.mixin;

import com.avp.common.data.fixer.AVPDataFixerRegistry;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MappedRegistry.class})
public abstract class MixinRegistry_ApplyDataFixes<T>
implements WritableRegistry<T> {
    @Shadow
    @Final
    private Map<ResourceLocation, Holder.Reference<T>> byLocation;

    @Shadow
    @Nullable
    private static <T> T getValueFromNullable(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Holder.Reference<T> reference) {
        return null;
    }

    @Inject(method={"get(Lnet/minecraft/resources/ResourceLocation;)Ljava/lang/Object;"}, at={@At(value="RETURN")}, cancellable=true)
    private void fixedGet(@Nullable ResourceLocation name, CallbackInfoReturnable<@Nullable T> cir) {
        Object original = cir.getReturnValue();
        Object fixed = this.convertResourceLocation(name, original);
        if (fixed != original) {
            cir.setReturnValue(fixed);
        }
    }

    @Inject(method={"get(Lnet/minecraft/resources/ResourceKey;)Ljava/lang/Object;"}, at={@At(value="RETURN")}, cancellable=true)
    private void fixedGet(@Nullable ResourceKey<T> key, CallbackInfoReturnable<@Nullable T> cir) {
        if (key != null) {
            Object original = cir.getReturnValue();
            Object fixed = this.convertResourceLocation(key.location(), original);
            if (fixed != original) {
                cir.setReturnValue(fixed);
            }
        }
    }

    @Inject(method={"getHolder(Lnet/minecraft/resources/ResourceLocation;)Ljava/util/Optional;"}, at={@At(value="RETURN")}, cancellable=true)
    private void fixedGetHolder(@Nullable ResourceLocation name, CallbackInfoReturnable<Optional<Holder.Reference<T>>> cir) {
        Holder.Reference original;
        Holder.Reference<T> fixed;
        if (name != null && (fixed = this.convertResourceLocationHolder(name, original = (Holder.Reference)((Optional)cir.getReturnValue()).orElse(null))) != original) {
            cir.setReturnValue(Optional.ofNullable(fixed));
        }
    }

    @Inject(method={"getOrCreateHolderOrThrow"}, at={@At(value="RETURN")}, cancellable=true)
    private void fixedGetOrCreateHolderOrThrow(ResourceKey<T> key, CallbackInfoReturnable<Holder.Reference<T>> cir) {
        if (key != null) {
            Holder.Reference original = (Holder.Reference)cir.getReturnValue();
            Holder.Reference<T> fixed = this.convertResourceLocationHolder(key.location(), original);
            if (fixed != original) {
                cir.setReturnValue(fixed);
            }
        }
    }

    @Unique
    @Nullable
    private T convertResourceLocation(@Nullable ResourceLocation name, @Nullable T original) {
        ResourceLocation fixed;
        if (name != null && (fixed = AVPDataFixerRegistry.getFixedValueInRegistry(this, name)) != null) {
            return MixinRegistry_ApplyDataFixes.getValueFromNullable(this.byLocation.get(fixed));
        }
        return original;
    }

    @Unique
    @Nullable
    private Holder.Reference<T> convertResourceLocationHolder(@Nullable ResourceLocation name, @Nullable Holder.Reference<T> original) {
        ResourceLocation fixed;
        if (name != null && (fixed = AVPDataFixerRegistry.getFixedValueInRegistry(this, name)) != null) {
            return this.byLocation.get(fixed);
        }
        return original;
    }
}

