/*
 * Decompiled with CFR 0.152.
 */
package com.avp.neoforge.client;

import com.avp.client.AVPClient;
import com.avp.client.input.keybind.KeyPressHandler;
import com.avp.neoforge.service.NeoForgeClientRegistryService;
import com.avp.service.Services;
import com.just.core.functional.tuple.Tuple2;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.common.NeoForge;

@EventBusSubscriber(modid="avp", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class AVPNeoForgeClient {
    private static final NeoForgeClientRegistryService CLIENT_REGISTRY = (NeoForgeClientRegistryService)Services.CLIENT_REGISTRY;

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        CLIENT_REGISTRY.getArmorRendererPairs().forEach(pair -> CLIENT_REGISTRY.registerArmorRendererImmediately((Supplier)pair.v1(), (List)pair.v2()));
        CLIENT_REGISTRY.getItemRendererPairs().forEach(pair -> CLIENT_REGISTRY.registerItemRendererImmediately((Item)((Supplier)pair.v1()).get(), (Function)pair.v2()));
        CLIENT_REGISTRY.getBlockRenderLayerPairs().forEach(pair -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)((Supplier)pair.v1()).get()), (RenderType)((RenderType)pair.v2())));
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        CLIENT_REGISTRY.getItemColorPairs().forEach(pair -> ((List)pair.v2()).forEach(itemSupplier -> event.getItemColors().register((ItemColor)pair.v1(), new ItemLike[]{(ItemLike)itemSupplier.get()})));
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        CLIENT_REGISTRY.getEntityRendererPairs().forEach(pair -> {
            EntityType entityType = (EntityType)((Supplier)pair.v1()).get();
            EntityRendererProvider entityRendererProvider = (EntityRendererProvider)pair.v2();
            event.registerEntityRenderer(entityType, entityRendererProvider);
        });
        CLIENT_REGISTRY.getBlockEntityRendererPairs().forEach(pair -> {
            BlockEntityType blockEntityType = (BlockEntityType)((Supplier)pair.v1()).get();
            BlockEntityRendererProvider blockEntityRendererProvider = (BlockEntityRendererProvider)pair.v2();
            event.registerBlockEntityRenderer(blockEntityType, blockEntityRendererProvider);
        });
    }

    @SubscribeEvent
    public static void registerBindings(RegisterKeyMappingsEvent event) {
        CLIENT_REGISTRY.getKeyMappingHandlerPairSuppliers().forEach(keyMappingSupplier -> event.register((KeyMapping)((Tuple2)keyMappingSupplier.get()).v1()));
    }

    public static void onClientTick(ClientTickEvent.Post event) {
        CLIENT_REGISTRY.getKeyMappingHandlerPairSuppliers().forEach(keyMappingSupplier -> {
            KeyMapping keyMapping = (KeyMapping)((Tuple2)keyMappingSupplier.get()).v1();
            Consumer keyInteractTypeConsumer = (Consumer)((Tuple2)keyMappingSupplier.get()).v2();
            KeyPressHandler.handle(keyMapping, keyInteractTypeConsumer);
        });
    }

    @SubscribeEvent
    public static void registerMenuScreens(RegisterMenuScreensEvent event) {
        CLIENT_REGISTRY.getMenuScreenConstructorPairs().forEach(pair -> {
            MenuType menuType = (MenuType)((Supplier)pair.v1()).get();
            MenuScreens.ScreenConstructor screenConstructor = (MenuScreens.ScreenConstructor)pair.v2();
            event.register(menuType, screenConstructor);
        });
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        CLIENT_REGISTRY.getParticleProviderFactoryPairs().forEach(pair -> {
            ParticleType particleType = (ParticleType)((Supplier)pair.v1()).get();
            ParticleEngine.SpriteParticleRegistration spriteParticleRegistration = (ParticleEngine.SpriteParticleRegistration)pair.v2();
            event.registerSpriteSet(particleType, spriteParticleRegistration);
        });
    }

    static {
        AVPClient.initialize();
        NeoForge.EVENT_BUS.addListener(AVPNeoForgeClient::onClientTick);
    }
}

