/*
 * Decompiled with CFR 0.152.
 */
package com.avp.neoforge.service;

import com.avp.common.registry.init.AVPMobCategoryData;
import com.avp.neoforge.common.item.NeoForgeGunItem;
import com.avp.neoforge.common.item.NeoForgeOldPainlessItem;
import com.avp.service.BridgeService;
import com.human.common.gameplay.item.gun.GunConfig;
import java.util.function.Supplier;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.neoforged.fml.common.asm.enumextension.EnumProxy;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;
import org.jetbrains.annotations.NotNull;

public class NeoForgeBridgeService
implements BridgeService {
    public static final EnumProxy<MobCategory> ALIEN_MOB_CATEGORY_ENUM_PROXY = NeoForgeBridgeService.fromMobCategoryData(AVPMobCategoryData.ALIEN);
    public static final EnumProxy<MobCategory> OVOMORPH_MOB_CATEGORY_ENUM_PROXY = NeoForgeBridgeService.fromMobCategoryData(AVPMobCategoryData.OVOMORPH);
    public static final EnumProxy<MobCategory> PREDATOR_MOB_CATEGORY_ENUM_PROXY = NeoForgeBridgeService.fromMobCategoryData(AVPMobCategoryData.PREDATOR);

    @NotNull
    private static EnumProxy<MobCategory> fromMobCategoryData(AVPMobCategoryData.Data data) {
        return new EnumProxy(MobCategory.class, new Object[]{data.name(), data.max(), data.isFriendly(), data.isPersistent(), data.despawnDistance()});
    }

    @Override
    public Supplier<Item> createGunSupplier(GunConfig gunConfig) {
        return () -> new NeoForgeGunItem(gunConfig);
    }

    @Override
    public Supplier<Item> createOldPainlessSupplier() {
        return NeoForgeOldPainlessItem::new;
    }

    @Override
    public <E extends Mob> Supplier<SpawnEggItem> createSpawnEggSupplier(Supplier<EntityType<E>> entityType, int primaryEggColour, int secondaryEggColour, Item.Properties itemProperties) {
        return () -> new DeferredSpawnEggItem(entityType, primaryEggColour, secondaryEggColour, itemProperties);
    }

    @Override
    public MobCategory getAlienMobCategory() {
        return (MobCategory)ALIEN_MOB_CATEGORY_ENUM_PROXY.getValue();
    }

    @Override
    public MobCategory getOvomorphMobCategory() {
        return (MobCategory)OVOMORPH_MOB_CATEGORY_ENUM_PROXY.getValue();
    }

    @Override
    public MobCategory getPredatorMobCategory() {
        return (MobCategory)PREDATOR_MOB_CATEGORY_ENUM_PROXY.getValue();
    }
}

