/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.block;

import com.avp.common.registry.key.AVPDamageTypeKeys;
import com.human.common.gameplay.entity.living.human.marine.Marine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class RazorWireBlock
extends Block {
    private static final VoxelShape SHAPE = Block.box((double)0.8, (double)0.0, (double)0.8, (double)15.2, (double)15.0, (double)15.2);
    private static final Vec3 MOVEMENT_MODIFIER = new Vec3((double)0.8f, 0.75, (double)0.8f);

    public RazorWireBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected boolean isPathfindable(@NotNull BlockState blockState, @NotNull PathComputationType pathComputationType) {
        return false;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState blockState, @NotNull BlockGetter blockGetter, @NotNull BlockPos blockPos, @NotNull CollisionContext collisionContext) {
        return SHAPE;
    }

    protected void entityInside(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        entity.makeStuckInBlock(blockState, MOVEMENT_MODIFIER);
        if (!(level.isClientSide || entity.xOld == entity.getX() && entity.yOld == entity.getY() && entity.zOld == entity.getZ() || entity instanceof Marine)) {
            double deltaX = Math.abs(entity.getX() - entity.xOld);
            double deltaY = Math.abs(entity.getY() - entity.yOld);
            double deltaZ = Math.abs(entity.getZ() - entity.zOld);
            if (deltaX >= (double)0.003f || deltaY >= (double)0.003f || deltaZ >= (double)0.003f) {
                Registry registry = entity.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
                DamageSource damageSource = new DamageSource((Holder)registry.getHolderOrThrow(AVPDamageTypeKeys.RAZOR_WIRE));
                entity.hurt(damageSource, 4.0f);
            }
        }
    }
}

