/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.block;

import com.avp.common.gameplay.block.property.BlockProperties;
import com.human.common.gameplay.entity.machine.SentryTurret;
import com.human.common.registry.init.entity_type.HumanEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SentryTurretBlock
extends Block {
    public SentryTurretBlock() {
        super(BlockProperties.STEEL.build().noOcclusion());
    }

    public void setPlacedBy(Level level, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        if (level.isClientSide() || !(level instanceof ServerLevel)) {
            super.setPlacedBy(level, pos, state, placer, stack);
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        SentryTurret sentryTurret = (SentryTurret)HumanEntityTypes.SENTRY_TURRET.get().create((Level)serverLevel);
        if (sentryTurret == null) {
            return;
        }
        sentryTurret.setPos(pos.getCenter());
        if (placer != null) {
            sentryTurret.setOwner((Entity)placer);
            float placerYaw = placer.getYRot();
            float turretYaw = (placerYaw + 180.0f) % 360.0f;
            sentryTurret.setYRot(turretYaw);
            sentryTurret.setYHeadRot(turretYaw);
            sentryTurret.setYBodyRot(turretYaw);
        }
        serverLevel.addFreshEntity((Entity)sentryTurret);
        level.removeBlock(pos, false);
    }
}

