/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.block.entity.power.impl;

import com.avp.common.registry.init.AVPBlockEntityTypes;
import com.avp.common.registry.init.block.AVPBlocks;
import com.human.common.gameplay.block.IndustrialFurnaceBlock;
import com.human.common.gameplay.block.entity.power.PowerNodeBlockEntity;
import com.human.common.gameplay.power.PowerNode;
import com.just.core.functional.function.Function;
import com.just.core.functional.function.Lazy;
import com.lib.common.util.DirectionUtil;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.BlastFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.SmokerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ThermalGeneratorBlockEntity
extends PowerNodeBlockEntity
implements PowerNode.PowerProducer {
    private static final Lazy<Map<Block, Function<BlockState, Integer>>> HEAT_VALUES = Lazy.of(() -> Map.ofEntries(Map.entry(Blocks.LAVA, $ -> 400), Map.entry(Blocks.LAVA_CAULDRON, $ -> 300), Map.entry(Blocks.FIRE, $ -> 160), Map.entry(Blocks.SOUL_FIRE, $ -> 120), Map.entry(Blocks.CAMPFIRE, $ -> 100), Map.entry(Blocks.MAGMA_BLOCK, $ -> 80), Map.entry(Blocks.SOUL_CAMPFIRE, $ -> 60), Map.entry(Blocks.LANTERN, $ -> 30), Map.entry(Blocks.TORCH, $ -> 20), Map.entry(Blocks.WALL_TORCH, $ -> 20), Map.entry(Blocks.REDSTONE_TORCH, $ -> 10), Map.entry(Blocks.REDSTONE_WALL_TORCH, $ -> 10), Map.entry(Blocks.BLAST_FURNACE, state -> (Boolean)state.getValue((Property)BlastFurnaceBlock.LIT) != false ? 200 : 0), Map.entry(Blocks.FURNACE, state -> (Boolean)state.getValue((Property)FurnaceBlock.LIT) != false ? 180 : 0), Map.entry(Blocks.SMOKER, state -> (Boolean)state.getValue((Property)SmokerBlock.LIT) != false ? 170 : 0), Map.entry(AVPBlocks.INDUSTRIAL_FURNACE.get(), state -> (Boolean)state.getValue((Property)IndustrialFurnaceBlock.LIT) != false ? 190 : 0)));

    public ThermalGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super(AVPBlockEntityTypes.THERMAL_GENERATOR.get(), pos, state);
    }

    @Override
    public long getAvailablePower() {
        if (this.level == null || this.level.isClientSide) {
            return 0L;
        }
        int totalHeat = 0;
        for (Direction direction : DirectionUtil.VALUES) {
            BlockPos neighborPos = this.worldPosition.relative(direction);
            BlockState neighborState = this.level.getBlockState(neighborPos);
            Block neighborBlock = neighborState.getBlock();
            Function heatFn = (Function)((Map)HEAT_VALUES.get()).get(neighborBlock);
            if (heatFn == null) continue;
            totalHeat += ((Integer)heatFn.apply((Object)neighborState)).intValue();
        }
        return totalHeat;
    }

    @Override
    public long extractPower(long maxAmount) {
        return maxAmount;
    }
}

