/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.block.power;

import com.human.common.gameplay.power.PowerNode;
import com.human.common.gameplay.power.PowerSystem;
import com.human.common.gameplay.power.grid.PowerGridManager;
import com.lib.common.util.DirectionUtil;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class CableBlock
extends Block {
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = Map.of(Direction.NORTH, NORTH, Direction.SOUTH, SOUTH, Direction.EAST, EAST, Direction.WEST, WEST, Direction.UP, UP, Direction.DOWN, DOWN);
    private static final VoxelShape CORE = CableBlock.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape SIDE_NORTH = CableBlock.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
    private static final VoxelShape SIDE_SOUTH = CableBlock.box((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape SIDE_EAST = CableBlock.box((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape SIDE_WEST = CableBlock.box((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    private static final VoxelShape SIDE_UP = CableBlock.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape SIDE_DOWN = CableBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    private static final VoxelShape[] SHAPES_BY_MASK = CableBlock.makeShapes();

    private static VoxelShape[] makeShapes() {
        VoxelShape[] voxelShapes = new VoxelShape[64];
        for (int mask = 0; mask < 64; ++mask) {
            VoxelShape voxelShape = CORE;
            if ((mask & 1) != 0) {
                voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)SIDE_NORTH);
            }
            if ((mask & 2) != 0) {
                voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)SIDE_SOUTH);
            }
            if ((mask & 4) != 0) {
                voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)SIDE_EAST);
            }
            if ((mask & 8) != 0) {
                voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)SIDE_WEST);
            }
            if ((mask & 0x10) != 0) {
                voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)SIDE_UP);
            }
            if ((mask & 0x20) != 0) {
                voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)SIDE_DOWN);
            }
            voxelShapes[mask] = voxelShape.optimize();
        }
        return voxelShapes;
    }

    private static int maskFromState(BlockState s) {
        int mask = 0;
        if (((Boolean)s.getValue((Property)NORTH)).booleanValue()) {
            mask |= 1;
        }
        if (((Boolean)s.getValue((Property)SOUTH)).booleanValue()) {
            mask |= 2;
        }
        if (((Boolean)s.getValue((Property)EAST)).booleanValue()) {
            mask |= 4;
        }
        if (((Boolean)s.getValue((Property)WEST)).booleanValue()) {
            mask |= 8;
        }
        if (((Boolean)s.getValue((Property)UP)).booleanValue()) {
            mask |= 0x10;
        }
        if (((Boolean)s.getValue((Property)DOWN)).booleanValue()) {
            mask |= 0x20;
        }
        return mask;
    }

    public CableBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = this.defaultBlockState();
        for (Direction direction : DirectionUtil.VALUES) {
            BlockPos neighborPos = pos.relative(direction);
            state = (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(this.canConnectTo((LevelAccessor)level, neighborPos)));
        }
        return state;
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        return (BlockState)state.setValue((Property)PROPERTY_BY_DIRECTION.get(direction), (Comparable)Boolean.valueOf(this.canConnectTo(level, neighborPos)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        return SHAPES_BY_MASK[CableBlock.maskFromState(state)];
    }

    @NotNull
    public VoxelShape getCollisionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        return SHAPES_BY_MASK[CableBlock.maskFromState(state)];
    }

    @NotNull
    public VoxelShape getOcclusionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return SHAPES_BY_MASK[CableBlock.maskFromState(state)];
    }

    public boolean propagatesSkylightDown(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return true;
    }

    public int getLightBlock(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return 0;
    }

    public boolean useShapeForLightOcclusion(@NotNull BlockState state) {
        return true;
    }

    protected void onPlace(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, blockPos, oldState, movedByPiston);
        if (level.isClientSide) {
            return;
        }
        PowerGridManager manager = PowerSystem.get((ServerLevel)level);
        for (Direction direction : DirectionUtil.VALUES) {
            BlockPos neighbor = blockPos.relative(direction);
            if (!this.canConnectTo((LevelAccessor)level, neighbor)) continue;
            manager.union(blockPos, neighbor);
        }
    }

    protected void onRemove(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean movedByPiston) {
        if (!level.isClientSide && state.getBlock() != newState.getBlock()) {
            PowerSystem.get((ServerLevel)level).splitGrid(level, pos);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    private boolean canConnectTo(LevelAccessor level, BlockPos neighbor) {
        return this.canConnectTo(level, neighbor, level.getBlockState(neighbor));
    }

    private boolean canConnectTo(LevelAccessor level, BlockPos neighbor, BlockState neighborState) {
        return neighborState.getBlock() instanceof CableBlock || level.getBlockEntity(neighbor) instanceof PowerNode;
    }
}

