/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item.canister;

import com.avp.common.registry.init.item.AVPItems;
import com.human.common.data.HumanAdvancements;
import com.human.common.registry.init.HumanDataComponents;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CanisterItem
extends Item
implements DispensibleContainerItem {
    public final Fluid content;
    public static final int MAX_CAPACITY = 8;

    public CanisterItem(Fluid content, Item.Properties properties) {
        super(properties);
        this.content = content;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        int currentContentAmount = (Integer)stack.getOrDefault(HumanDataComponents.CANISTER_CAPACITY.get(), (Object)0);
        if (currentContentAmount == 0) {
            return;
        }
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.avp.capacity").append(currentContentAmount + "/8"));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand usedHand) {
        Direction hitDir;
        BlockPos relativePos;
        ItemStack canisterStack = player.getItemInHand(usedHand);
        BlockHitResult hitResult = CanisterItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)(this.isFluidPlacementAction(player) ? ClipContext.Fluid.NONE : ClipContext.Fluid.SOURCE_ONLY));
        if (CanisterItem.isInvalidHitResult(hitResult)) {
            return InteractionResultHolder.fail((Object)canisterStack);
        }
        BlockPos hitPos = hitResult.getBlockPos();
        if (!CanisterItem.canPlayerInteract(level, player, hitPos, relativePos = hitPos.relative(hitDir = hitResult.getDirection()), hitDir, canisterStack)) {
            return InteractionResultHolder.fail((Object)canisterStack);
        }
        BlockState hitState = level.getBlockState(hitPos);
        if (CanisterItem.isFluidPickupAction(player, hitState)) {
            return this.handleFluidPickup(player, level, canisterStack, hitPos, hitState);
        }
        if (this.isFluidPlacementAction(player)) {
            return this.handleFluidPlacement(player, level, canisterStack, hitResult, hitPos, hitState, relativePos);
        }
        return InteractionResultHolder.fail((Object)canisterStack);
    }

    public static boolean isInvalidHitResult(BlockHitResult hitResult) {
        return hitResult.getType() == HitResult.Type.MISS || hitResult.getType() != HitResult.Type.BLOCK;
    }

    public static boolean canPlayerInteract(Level level, Player player, BlockPos hitPos, BlockPos relativePos, Direction hitDir, ItemStack stack) {
        return level.mayInteract(player, hitPos) && player.mayUseItemAt(relativePos, hitDir, stack);
    }

    public static boolean isFluidPickupAction(Player player, BlockState hitState) {
        return !player.isShiftKeyDown() && hitState.getBlock() instanceof BucketPickup;
    }

    private boolean isFluidPlacementAction(Player player) {
        return player.isShiftKeyDown() && this.content != Fluids.EMPTY;
    }

    private InteractionResultHolder<ItemStack> handleFluidPickup(Player player, Level level, ItemStack canisterStack, BlockPos hitPos, BlockState hitState) {
        BucketPickup bucketPickup = (BucketPickup)hitState.getBlock();
        if ((Integer)canisterStack.getOrDefault(HumanDataComponents.CANISTER_CAPACITY.get(), (Object)0) >= 8) {
            return InteractionResultHolder.fail((Object)canisterStack);
        }
        ItemStack filledStack = this.pickupBlock(player, level, canisterStack, bucketPickup, hitPos, hitState);
        if (filledStack.isEmpty()) {
            return InteractionResultHolder.fail((Object)canisterStack);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        bucketPickup.getPickupSound().ifPresent(sound -> player.playSound(sound, 1.0f, 1.0f));
        level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, hitPos);
        ItemStack resultStack = this.content != Fluids.EMPTY ? CanisterItem.updateCapacity((LivingEntity)player, filledStack, 1) : ItemUtils.createFilledResult((ItemStack)canisterStack, (Player)player, (ItemStack)filledStack);
        if (!level.isClientSide) {
            CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, filledStack);
        }
        return InteractionResultHolder.sidedSuccess((Object)resultStack, (boolean)level.isClientSide());
    }

    private InteractionResultHolder<ItemStack> handleFluidPlacement(Player player, Level level, ItemStack canisterStack, BlockHitResult hitResult, BlockPos hitPos, BlockState hitState, BlockPos relativePos) {
        BlockPos targetPos;
        BlockPos blockPos = targetPos = hitState.getBlock() instanceof LiquidBlockContainer && this.content == Fluids.WATER ? hitPos : relativePos;
        if (!this.emptyContents(player, level, targetPos, hitResult)) {
            return InteractionResultHolder.fail((Object)canisterStack);
        }
        this.checkExtraContent(player, level, canisterStack, targetPos);
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.PLACED_BLOCK.trigger((ServerPlayer)player, targetPos, canisterStack);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        ItemStack resultStack = (Integer)canisterStack.getOrDefault(HumanDataComponents.CANISTER_CAPACITY.get(), (Object)0) > 1 && !player.isCreative() ? CanisterItem.updateCapacity((LivingEntity)player, canisterStack, -1) : ItemUtils.createFilledResult((ItemStack)canisterStack, (Player)player, (ItemStack)CanisterItem.getEmptySuccessItem(canisterStack, player));
        return InteractionResultHolder.sidedSuccess((Object)resultStack, (boolean)level.isClientSide());
    }

    public static ItemStack updateCapacity(LivingEntity livingEntity, ItemStack stack, int amount) {
        int currentContentAmount = (Integer)stack.getOrDefault(HumanDataComponents.CANISTER_CAPACITY.get(), (Object)0);
        int newAmount = Mth.clamp((int)(currentContentAmount + amount), (int)0, (int)8);
        if (newAmount >= 8 && livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            HumanAdvancements.FILL_CANISTER.grant(serverPlayer);
        }
        stack.applyComponents(DataComponentPatch.builder().set(HumanDataComponents.CANISTER_CAPACITY.get(), (Object)newAmount).build());
        return stack;
    }

    private ItemStack pickupBlock(Player player, Level level, ItemStack canisterStack, BucketPickup bucketPickup, BlockPos blockPos, BlockState blockState) {
        ItemStack bucketItem = bucketPickup.pickupBlock(player, (LevelAccessor)level, blockPos, blockState);
        if (this.content != Fluids.EMPTY) {
            return canisterStack;
        }
        if (bucketItem.is(Items.WATER_BUCKET)) {
            return new ItemStack((ItemLike)AVPItems.WATER_CANISTER.get());
        }
        if (bucketItem.is(Items.LAVA_BUCKET)) {
            return new ItemStack((ItemLike)AVPItems.LAVA_CANISTER.get());
        }
        if (bucketItem.is(Items.POWDER_SNOW_BUCKET)) {
            return new ItemStack((ItemLike)AVPItems.POWDER_SNOW_CANISTER.get());
        }
        return canisterStack;
    }

    public static ItemStack getEmptySuccessItem(ItemStack canisterStack, Player player) {
        return !player.hasInfiniteMaterials() ? new ItemStack((ItemLike)AVPItems.CANISTER.get()) : canisterStack;
    }

    public boolean emptyContents(@Nullable Player player, @NotNull Level level, @NotNull BlockPos pos, @Nullable BlockHitResult result) {
        LiquidBlockContainer liquidBlockContainer;
        Fluid fluid = this.content;
        if (!(fluid instanceof FlowingFluid)) {
            return false;
        }
        FlowingFluid flowingFluid = (FlowingFluid)fluid;
        BlockState blockState = level.getBlockState(pos);
        Block block = blockState.getBlock();
        boolean isReplaceable = blockState.canBeReplaced(this.content);
        boolean canEmptyHere = !blockState.isAir() && !isReplaceable ? block instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)block).canPlaceLiquid(player, (BlockGetter)level, pos, blockState, this.content) : true;
        if (!canEmptyHere) {
            return result != null && this.emptyContents(player, level, result.getBlockPos().relative(result.getDirection()), null);
        }
        if (level.dimensionType().ultraWarm() && this.content.is(FluidTags.WATER)) {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            level.playSound(player, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.8f);
            for (int i = 0; i < 8; ++i) {
                level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)x + Math.random(), (double)y + Math.random(), (double)z + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (block instanceof LiquidBlockContainer) {
            liquidBlockContainer = (LiquidBlockContainer)block;
            if (this.content == Fluids.WATER) {
                liquidBlockContainer.placeLiquid((LevelAccessor)level, pos, blockState, flowingFluid.getSource(false));
                this.playEmptySound(player, (LevelAccessor)level, pos);
                return true;
            }
        }
        if (!level.isClientSide && isReplaceable && !blockState.liquid()) {
            level.destroyBlock(pos, true);
        }
        if (!level.setBlock(pos, this.content.defaultFluidState().createLegacyBlock(), 11) && !blockState.getFluidState().isSource()) {
            return false;
        }
        this.playEmptySound(player, (LevelAccessor)level, pos);
        return true;
    }

    protected void playEmptySound(@Nullable Player player, LevelAccessor level, BlockPos pos) {
        SoundEvent soundEvent = this.content.is(FluidTags.LAVA) ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY;
        level.playSound(player, pos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PLACE, pos);
    }
}

