/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item.gun;

import com.avp.common.registry.init.AVPSoundEvents;
import com.human.common.gameplay.item.gun.attack.GunAttackAction;
import com.human.common.gameplay.item.gun.attack.hitscan.HitScanGunAttackAction;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.Nullable;

public record FireModeConfig(int consumedAmmunitionPerShot, int cooldownInTicks, float damage, float knockback, Supplier<SoundEvent> primaryShootSoundEvent, int primaryShootSoundFrequencyInTicks, int range, float recoil, Supplier<SoundEvent> reloadFinishSoundEvent, Supplier<SoundEvent> reloadStartSoundEvent, @Nullable Supplier<SoundEvent> secondaryShootSoundEvent, int secondaryShootSoundFrequencyInTicks, int shootDelayInTicks, @Nullable Supplier<SoundEvent> shootFinishSoundEvent, @Nullable Supplier<SoundEvent> shootStartSoundEvent, GunAttackAction gunAttackAction) {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int consumedAmmunitionPerShot = 1;
        private int cooldownInTicks = 0;
        private float damage = 1.0f;
        private float knockback = 0.0f;
        private Supplier<SoundEvent> primaryShootSoundEvent = AVPSoundEvents.WEAPON_GENERIC_SHOOT;
        private int primaryShootSoundFrequencyInTicks = 0;
        private int range = 16;
        private float recoil = 0.0f;
        private Supplier<SoundEvent> reloadFinishSoundEvent = AVPSoundEvents.WEAPON_GENERIC_RELOAD;
        private Supplier<SoundEvent> reloadStartSoundEvent = AVPSoundEvents.WEAPON_GENERIC_RELOAD;
        private Supplier<SoundEvent> secondaryShootSoundEvent;
        private int secondaryShootSoundFrequencyInTicks = 0;
        private int shootDelayInTicks = 0;
        private Supplier<SoundEvent> shootFinishSoundEvent;
        private Supplier<SoundEvent> shootStartSoundEvent;
        private GunAttackAction gunAttackAction = HitScanGunAttackAction.INSTANCE;

        private Builder() {
        }

        public Builder withConsumedAmmunitionPerShot(int consumedAmmunitionPerShot) {
            this.consumedAmmunitionPerShot = consumedAmmunitionPerShot;
            return this;
        }

        public Builder withCooldownInTicks(int cooldownInTicks) {
            this.cooldownInTicks = cooldownInTicks;
            return this;
        }

        public Builder withDamage(float damage) {
            this.damage = damage;
            return this;
        }

        public Builder withKnockback(float knockback) {
            this.knockback = knockback;
            return this;
        }

        public Builder withPrimaryShootSound(Supplier<SoundEvent> primaryShootSoundEvent) {
            this.primaryShootSoundEvent = primaryShootSoundEvent;
            return this;
        }

        public Builder withPrimaryShootSoundFrequencyInTicks(int primaryShootSoundFrequencyInTicks) {
            this.primaryShootSoundFrequencyInTicks = primaryShootSoundFrequencyInTicks;
            return this;
        }

        public Builder withRange(int range) {
            this.range = range;
            return this;
        }

        public Builder withRecoil(float recoil) {
            this.recoil = recoil;
            return this;
        }

        public Builder withReloadFinishSound(Supplier<SoundEvent> reloadFinishSoundEvent) {
            this.reloadFinishSoundEvent = reloadFinishSoundEvent;
            return this;
        }

        public Builder withReloadStartSound(Supplier<SoundEvent> reloadStartSoundEvent) {
            this.reloadStartSoundEvent = reloadStartSoundEvent;
            return this;
        }

        public Builder withSecondaryShootSoundFrequencyInTicks(int secondaryShootSoundFrequencyInTicks) {
            this.secondaryShootSoundFrequencyInTicks = secondaryShootSoundFrequencyInTicks;
            return this;
        }

        public Builder withSecondaryShootSound(Supplier<SoundEvent> secondaryShootSoundEvent) {
            this.secondaryShootSoundEvent = secondaryShootSoundEvent;
            return this;
        }

        public Builder withShootDelayInTicks(int shootDelayInTicks) {
            this.shootDelayInTicks = shootDelayInTicks;
            return this;
        }

        public Builder withShootFinishSound(Supplier<SoundEvent> shootFinishSoundEvent) {
            this.shootFinishSoundEvent = shootFinishSoundEvent;
            return this;
        }

        public Builder withShootStartSound(Supplier<SoundEvent> shootStartSoundEvent) {
            this.shootStartSoundEvent = shootStartSoundEvent;
            return this;
        }

        public Builder withGunAttackAction(GunAttackAction gunAttackAction) {
            this.gunAttackAction = gunAttackAction;
            return this;
        }

        public FireModeConfig build() {
            return new FireModeConfig(this.consumedAmmunitionPerShot, this.cooldownInTicks, this.damage, this.knockback, this.primaryShootSoundEvent, this.primaryShootSoundFrequencyInTicks, this.range, this.recoil, this.reloadFinishSoundEvent, this.reloadStartSoundEvent, this.secondaryShootSoundEvent, this.secondaryShootSoundFrequencyInTicks, this.shootDelayInTicks, this.shootFinishSoundEvent, this.shootStartSoundEvent, this.gunAttackAction);
        }
    }
}

