/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item.gun.attack.projectile;

import com.avp.common.network.packet.S2CGunRecoilPayload;
import com.avp.service.Services;
import com.human.common.gameplay.entity.projectile.Flamethrow;
import com.human.common.gameplay.item.gun.attack.GunAttackAction;
import com.human.common.gameplay.item.gun.attack.GunAttackConfig;
import com.human.common.gameplay.item.gun.pipeline.GunShootResult;
import com.lib.common.gameplay.util.EnchantmentUtil;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class FlamethrowProjectileGunAttackAction
implements GunAttackAction {
    public static final FlamethrowProjectileGunAttackAction INSTANCE = new FlamethrowProjectileGunAttackAction();

    private FlamethrowProjectileGunAttackAction() {
    }

    @Override
    public GunShootResult shoot(GunAttackConfig gunAttackConfig) {
        LivingEntity shooter = gunAttackConfig.shooter();
        Level level = shooter.level();
        if (level.isClientSide) {
            return GunShootResult.FAILURE;
        }
        Flamethrow flamethrow = new Flamethrow(level, shooter);
        flamethrow.setEnhanced(EnchantmentUtil.getLevel(level, gunAttackConfig.gunItemStack(), (ResourceKey<Enchantment>)Enchantments.FLAME) > 0);
        flamethrow.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, 1.5f, 1.0f);
        if (shooter instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)shooter;
            Services.SERVER_NETWORKING.sendToClient(serverPlayer, new S2CGunRecoilPayload(gunAttackConfig.fireModeConfig().recoil()));
        }
        level.addFreshEntity((Entity)flamethrow);
        return GunShootResult.SHOT;
    }
}

