/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item.gun.attack.projectile;

import com.avp.common.network.packet.S2CGunRecoilPayload;
import com.avp.service.Services;
import com.human.common.gameplay.entity.projectile.Rocket;
import com.human.common.gameplay.item.gun.attack.GunAttackAction;
import com.human.common.gameplay.item.gun.attack.GunAttackConfig;
import com.human.common.gameplay.item.gun.pipeline.GunShootResult;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class RocketProjectileGunAttackAction
implements GunAttackAction {
    public static final RocketProjectileGunAttackAction INSTANCE = new RocketProjectileGunAttackAction();

    private RocketProjectileGunAttackAction() {
    }

    @Override
    public GunShootResult shoot(GunAttackConfig gunAttackConfig) {
        LivingEntity shooter = gunAttackConfig.shooter();
        Level level = shooter.level();
        if (level.isClientSide) {
            return GunShootResult.FAILURE;
        }
        Rocket rocket = new Rocket(level, shooter);
        rocket.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, 1.5f, 1.0f);
        if (shooter instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)shooter;
            Services.SERVER_NETWORKING.sendToClient(serverPlayer, new S2CGunRecoilPayload(gunAttackConfig.fireModeConfig().recoil()));
        }
        level.addFreshEntity((Entity)rocket);
        return GunShootResult.SHOT;
    }
}

