/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item.gun.pipeline.step.impl;

import com.human.common.gameplay.item.gun.pipeline.GunShootContext;
import com.human.common.gameplay.item.gun.pipeline.GunShootResult;
import com.human.common.gameplay.item.gun.pipeline.step.GunShootStep;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;

public class CheckShootDelayStep
implements GunShootStep {
    public static final CheckShootDelayStep INSTANCE = new CheckShootDelayStep();

    private CheckShootDelayStep() {
    }

    @Override
    public GunShootResult apply(GunShootContext context) {
        if (!context.shooter().level().isClientSide) {
            this.playShootStartSoundEffect(context);
        }
        return context.tickProgress() < context.fireModeConfig().shootDelayInTicks() ? GunShootResult.DELAYED : GunShootResult.CONTINUE;
    }

    private void playShootStartSoundEffect(GunShootContext context) {
        Supplier<SoundEvent> shootStartSoundEvent = context.fireModeConfig().shootStartSoundEvent();
        if (shootStartSoundEvent != null && context.isFirstTick()) {
            LivingEntity shooter = context.shooter();
            shooter.level().playSound(null, shooter.blockPosition(), shootStartSoundEvent.get(), SoundSource.PLAYERS);
        }
    }
}

