/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.level.patrol;

import com.avp.common.registry.tag.AVPBiomeTags;
import com.avp.common.registry.tag.AVPBlockTags;
import com.human.common.gameplay.entity.living.human.marine.Marine;
import com.human.common.registry.init.entity_type.HumanEntityTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;

public class MarinePatrolSpawner
implements CustomSpawner {
    private int nextTick;

    public int tick(@NotNull ServerLevel level, boolean spawnEnemies, boolean spawnFriendlies) {
        if (!spawnEnemies || !level.getGameRules().getBoolean(GameRules.RULE_DO_PATROL_SPAWNING)) {
            return 0;
        }
        RandomSource randomSource = level.random;
        --this.nextTick;
        if (this.nextTick > 0) {
            return 0;
        }
        this.nextTick += 12000 + randomSource.nextInt(1200);
        if (!this.isValidSpawnTime(level)) {
            return 0;
        }
        Player player = this.getRandomPlayer(level);
        if (player == null) {
            return 0;
        }
        BlockPos.MutableBlockPos mutableBlockPos = this.getRandomNearbyPosition(player, randomSource);
        if (!this.isValidSpawnLocation((BlockPos)mutableBlockPos, level)) {
            return 0;
        }
        return this.spawnPatrolMembers(level, mutableBlockPos);
    }

    private boolean isValidSpawnTime(ServerLevel level) {
        return level.random.nextInt(5) == 0;
    }

    private Player getRandomPlayer(ServerLevel level) {
        List players = level.players();
        if (players.isEmpty()) {
            return null;
        }
        ServerPlayer player = (ServerPlayer)players.get(level.random.nextInt(players.size()));
        return player.isSpectator() ? null : player;
    }

    private boolean isValidPlayerSpawn(Player player, ServerLevel level) {
        return !level.isCloseToVillage(player.blockPosition(), 2);
    }

    private BlockPos.MutableBlockPos getRandomNearbyPosition(Player player, RandomSource randomSource) {
        int xOffset = (24 + randomSource.nextInt(24)) * (randomSource.nextBoolean() ? -1 : 1);
        int zOffset = (24 + randomSource.nextInt(24)) * (randomSource.nextBoolean() ? -1 : 1);
        return player.blockPosition().mutable().move(xOffset, 0, zOffset);
    }

    private boolean isValidSpawnLocation(BlockPos pos, ServerLevel level) {
        if (!level.hasChunksAt(pos.getX() - 10, pos.getZ() - 10, pos.getX() + 10, pos.getZ() + 10)) {
            return false;
        }
        Holder biomeHolder = level.getBiome(pos);
        return biomeHolder.is(AVPBiomeTags.HAS_MARINE_CAMP_GRASS);
    }

    private int spawnPatrolMembers(ServerLevel level, BlockPos.MutableBlockPos startPos) {
        RandomSource randomSource = level.random;
        int difficulty = (int)Math.ceil(level.getCurrentDifficultyAt((BlockPos)startPos).getEffectiveDifficulty()) + 1;
        int spawnCount = 0;
        for (int i = 0; i < difficulty; ++i) {
            ++spawnCount;
            startPos.setY(level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)startPos).getY());
            this.spawnPatrolMember(level, (BlockPos)startPos);
            startPos.setX(startPos.getX() + randomSource.nextInt(5) - randomSource.nextInt(5));
            startPos.setZ(startPos.getZ() + randomSource.nextInt(5) - randomSource.nextInt(5));
        }
        return spawnCount;
    }

    private void spawnPatrolMember(ServerLevel level, BlockPos pos) {
        BlockState belowState = level.getBlockState(pos.below());
        TagKey<Block> spawnableBlock = AVPBlockTags.MARINE_SPAWN_BLOCKS;
        if (!belowState.is(Blocks.GRASS_BLOCK)) {
            return;
        }
        Marine marineMob = (Marine)HumanEntityTypes.MARINE.get().create((Level)level);
        if (marineMob == null) {
            return;
        }
        marineMob.setPos(pos.getX(), pos.getY(), pos.getZ());
        marineMob.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(pos), MobSpawnType.PATROL, null);
        level.addFreshEntityWithPassengers((Entity)marineMob);
    }
}

