/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.registry.init.entity_type;

import com.avp.common.registry.AVPDeferredHolder;
import com.avp.common.registry.init.entity_type.AVPEntityTypes;
import com.avp.service.Services;
import com.human.common.gameplay.entity.living.human.marine.Marine;
import com.human.common.gameplay.entity.machine.SentryTurret;
import com.human.common.gameplay.entity.nuke.MushroomCloudEntity;
import com.human.common.gameplay.entity.nuke.PrimedNuke;
import com.human.common.gameplay.entity.projectile.Flamethrow;
import com.human.common.gameplay.entity.projectile.Rocket;
import com.human.common.gameplay.entity.projectile.ThrownGrenade;
import com.human.common.gameplay.util.EyeColorGenerator;
import com.human.common.gameplay.util.HairColorGenerator;
import com.human.common.gameplay.util.SkinColorGenerator;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;

public class HumanEntityTypes {
    public static final AVPDeferredHolder<EntityType<Flamethrow>> FLAMETHROW = AVPEntityTypes.register("flamethrow", EntityType.Builder.of(Flamethrow::new, (MobCategory)MobCategory.MISC).sized(0.1f, 0.1f).clientTrackingRange(8).updateInterval(10));
    public static final AVPDeferredHolder<EntityType<ThrownGrenade>> GRENADE_THROWN = AVPEntityTypes.register("grenade_thrown", EntityType.Builder.of(ThrownGrenade::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f));
    public static final AVPDeferredHolder<EntityType<Marine>> MARINE = AVPEntityTypes.register("marine", EntityType.Builder.of((entityType, level) -> {
        Marine entity = new Marine((EntityType<? extends PathfinderMob>)entityType, level);
        RandomSource random = entity.getRandom();
        entity.isMale.set(random.nextBoolean());
        Boolean isMale = (Boolean)entity.isMale.get();
        if (isMale.booleanValue()) {
            entity.setBeardVariant(random.nextInt(3));
        }
        entity.eyeColor.set(EyeColorGenerator.random(random));
        entity.hairColor.set(HairColorGenerator.random(random));
        entity.hairVariant.set(random.nextInt(isMale != false ? 5 : 6));
        entity.skinColor.set(SkinColorGenerator.random(random));
        return entity;
    }, (MobCategory)MobCategory.CREATURE).sized(0.7f, 1.95f));
    public static final AVPDeferredHolder<EntityType<MushroomCloudEntity>> MUSHROOM_CLOUD = AVPEntityTypes.register("mushroom_cloud", EntityType.Builder.of(MushroomCloudEntity::new, (MobCategory)MobCategory.MISC));
    public static final AVPDeferredHolder<EntityType<PrimedNuke>> NUKE = AVPEntityTypes.register("nuke", EntityType.Builder.of(PrimedNuke::new, (MobCategory)MobCategory.MISC).sized(0.1f, 0.1f).noSummon().clientTrackingRange(100).updateInterval(100));
    public static final AVPDeferredHolder<EntityType<Rocket>> ROCKET = AVPEntityTypes.register("rocket", EntityType.Builder.of(Rocket::new, (MobCategory)MobCategory.MISC).sized(0.1f, 0.1f).clientTrackingRange(8).updateInterval(10));
    public static final AVPDeferredHolder<EntityType<SentryTurret>> SENTRY_TURRET = AVPEntityTypes.register("sentry_turret", EntityType.Builder.of(SentryTurret::new, (MobCategory)MobCategory.MISC).sized(1.0f, 1.0f).noSummon());

    public static void initialize() {
        Services.REGISTRY.registerEntityAttributes(MARINE, Marine::createMarineAttributes);
        Services.REGISTRY.registerEntityAttributes(SENTRY_TURRET, SentryTurret::createSentryTurretAttributes);
    }
}

