/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.data;

import com.avp.AVPResources;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;

public record AdvancementAccess(String group, String path) {
    public ResourceLocation getResourceLocation() {
        return AVPResources.location(this.group + "/" + this.path);
    }

    public String getTitleTranslationKey() {
        return "advancements." + this.group + "." + this.path + ".title";
    }

    public Component getTitleComponent() {
        return Component.translatable((String)this.getTitleTranslationKey());
    }

    public String getDescriptionTranslationKey() {
        return "advancements." + this.group + "." + this.path + ".description";
    }

    public Component getDescriptionComponent() {
        return Component.translatable((String)this.getDescriptionTranslationKey());
    }

    public void grant(ServerPlayer serverPlayer) {
        AdvancementHolder advancementHolder = serverPlayer.server.getAdvancements().get(this.getResourceLocation());
        if (advancementHolder == null) {
            return;
        }
        PlayerAdvancements advancements = serverPlayer.getAdvancements();
        AdvancementProgress progress = advancements.getOrStartProgress(advancementHolder);
        if (!progress.isDone()) {
            for (String criterionKey : progress.getRemainingCriteria()) {
                advancements.award(advancementHolder, criterionKey);
            }
        }
    }
}

