/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.entity.ai.action;

import com.avp.common.model.inventory.AVPInventoryBearer;
import com.lib.common.gameplay.entity.ai.GOAPConstants;
import com.lib.common.gameplay.entity.ai.util.ItemType;
import com.lib.common.gameplay.goap.GOAPAction;
import com.lib.common.gameplay.goap.TypedIdentifier;
import com.lib.common.gameplay.goap.condition.expression.GOAPExpression;
import com.lib.common.gameplay.goap.effect.GOAPEffect;
import com.lib.common.gameplay.goap.state.GOAPBlackboard;
import com.lib.common.gameplay.goap.state.GOAPWorldState;
import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class EquipItemAction<T extends LivingEntity>
extends GOAPAction<T> {
    private final InteractionHand interactionHand;
    private final ItemType itemType;

    public EquipItemAction(InteractionHand interactionHand, ItemType itemType) {
        this.interactionHand = interactionHand;
        this.itemType = itemType;
        TypedIdentifier<ItemType> typedIdentifier = interactionHand == InteractionHand.MAIN_HAND ? GOAPConstants.MAIN_HAND_ITEM_TYPE : GOAPConstants.OFF_HAND_ITEM_TYPE;
        this.addPrecondition(GOAPConstants.ITEM_TYPES_IN_INVENTORY, GOAPExpression.contains(itemType));
        this.addPrecondition(typedIdentifier, GOAPExpression.where(handItemType -> handItemType != itemType, typedIdentifier.identifier() + " is not " + String.valueOf(itemType)));
        this.addEffect(new GOAPEffect.Value<ItemType>(typedIdentifier, itemType));
    }

    @Override
    public boolean perform(T context, GOAPWorldState worldState, GOAPBlackboard blackboard) {
        Optional<ItemStack> itemStackOption = ((AVPInventoryBearer)context).getInventory().stream().filter(item -> ItemType.getForItem(item) == this.itemType).findFirst();
        itemStackOption.ifPresent(itemStack -> context.setItemInHand(this.interactionHand, new ItemStack((ItemLike)itemStack.getItem(), 1)));
        return ItemType.getForItem(context.getItemInHand(this.interactionHand)) == this.itemType;
    }
}

