/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.entity.manager;

import com.lib.common.gameplay.NBTSerializable;
import com.lib.common.gameplay.entity.manager.GeneContainer;
import com.lib.common.gameplay.entity.manager.GeneMap;
import com.lib.common.gameplay.gene.Gene;
import com.lib.common.gameplay.gene.GeneModifierKey;
import com.lib.common.gameplay.gene.GeneOperationType;
import com.lib.common.gameplay.gene.GeneRegistry;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class GeneManager
implements NBTSerializable {
    private final LivingEntity entity;
    private final GeneContainer geneContainer;

    public GeneManager(LivingEntity entity) {
        this.entity = entity;
        this.geneContainer = new GeneContainer();
    }

    public void tick() {
        GeneMap activeGeneMap = this.geneContainer.getActiveGeneMap();
        if (this.entity.level().isClientSide || !activeGeneMap.isDirty()) {
            return;
        }
        float oldMaxHealth = this.entity.getMaxHealth();
        boolean wasFullHealth = this.entity.getHealth() == oldMaxHealth;
        activeGeneMap.getDirtyKeys().forEach(this::applyGeneEffects);
        AttributeInstance maxHealthAttributeInstance = this.entity.getAttribute(Attributes.MAX_HEALTH);
        if (maxHealthAttributeInstance != null) {
            double newMax = maxHealthAttributeInstance.getValue();
            float currentHealth = this.entity.getHealth();
            if (wasFullHealth || (double)currentHealth > newMax) {
                this.entity.setHealth((float)newMax);
            }
        }
        activeGeneMap.clearDirtyKeys();
    }

    private void applyGeneEffects(GeneModifierKey dirtyGeneModifierKey) {
        GeneMap activeGeneMap = this.geneContainer.getActiveGeneMap();
        ResourceLocation id = dirtyGeneModifierKey.resourceLocation();
        Gene gene = GeneRegistry.getValueOrNull(id);
        if (gene == null) {
            return;
        }
        Gene gene2 = gene;
        Objects.requireNonNull(gene2);
        Gene gene3 = gene2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Gene.Attribute.class, Gene.Effect.class, Gene.Simple.class}, (Object)gene3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Gene.Attribute attribute = (Gene.Attribute)gene3;
                AttributeInstance attributeInstance = this.entity.getAttribute(attribute.attributeHolder());
                if (attributeInstance == null) break;
                boolean hasGeneModifier = activeGeneMap.hasGeneModifier(dirtyGeneModifierKey);
                if (hasGeneModifier) {
                    this.applyGeneAttributeBonus(dirtyGeneModifierKey, attributeInstance);
                    break;
                }
                attributeInstance.removeModifier(id);
                break;
            }
            case 1: {
                Gene.Effect effectGene = (Gene.Effect)gene3;
                effectGene.onChange().accept(this.entity);
                break;
            }
            case 2: {
                Gene.Simple simple = (Gene.Simple)gene3;
            }
        }
    }

    private void applyGeneAttributeBonus(GeneModifierKey geneModifierKey, AttributeInstance attributeInstance) {
        ResourceLocation id = geneModifierKey.resourceLocation();
        Gene gene = GeneRegistry.getValueOrNull(id);
        double bonusValue = this.geneContainer.getActiveGeneMap().getValue(gene, geneModifierKey.operation());
        double finalBonusValue = switch (geneModifierKey.operation()) {
            default -> throw new MatchException(null, null);
            case GeneOperationType.ADDITIVE -> bonusValue;
            case GeneOperationType.MULTIPLICATIVE -> attributeInstance.getBaseValue() * bonusValue;
        };
        AttributeModifier modifier = new AttributeModifier(id, finalBonusValue, AttributeModifier.Operation.ADD_VALUE);
        attributeInstance.addOrReplacePermanentModifier(modifier);
    }

    public GeneContainer getGeneContainer() {
        return this.geneContainer;
    }

    @Override
    public void load(CompoundTag compoundTag) {
        this.geneContainer.load(compoundTag);
    }

    @Override
    public void save(CompoundTag compoundTag) {
        this.geneContainer.save(compoundTag);
    }
}

