/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.gene;

import com.avp.common.registry.AVPDeferredHolder;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.gene.Gene;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class GeneRegistry {
    private static final Map<ResourceLocation, Gene> GENES_BY_RESOURCE_LOCATION = new HashMap<ResourceLocation, Gene>();
    private static final Map<Gene, ResourceLocation> RESOURCE_LOCATION_BY_VALUE = new HashMap<Gene, ResourceLocation>();

    @Nullable
    public static Gene getValueOrNull(ResourceLocation resourceLocation) {
        return GENES_BY_RESOURCE_LOCATION.get(resourceLocation);
    }

    @Nullable
    public static ResourceLocation getResourceLocationOrNull(AVPDeferredHolder<Gene> geneHolder) {
        return RESOURCE_LOCATION_BY_VALUE.get(geneHolder.get());
    }

    public static Option<Gene> getValue(ResourceLocation resourceLocation) {
        return Option.ofNullable((Object)GeneRegistry.getValueOrNull(resourceLocation));
    }

    public static Option<ResourceLocation> getResourceLocation(AVPDeferredHolder<Gene> geneHolder) {
        return Option.ofNullable((Object)GeneRegistry.getResourceLocationOrNull(geneHolder));
    }

    public static AVPDeferredHolder<Gene> register(Supplier<Gene> geneSupplier) {
        Gene gene = geneSupplier.get();
        ResourceLocation resourceLocation = gene.id();
        Holder holder = Holder.direct((Object)gene);
        GENES_BY_RESOURCE_LOCATION.put(resourceLocation, gene);
        RESOURCE_LOCATION_BY_VALUE.put(gene, resourceLocation);
        return new AVPDeferredHolder<Gene>(() -> gene, () -> holder);
    }
}

