/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.goap;

import com.lib.common.gameplay.goap.TypedIdentifier;
import com.lib.common.gameplay.goap.condition.GOAPCondition;
import com.lib.common.gameplay.goap.condition.GOAPConditionContainer;
import com.lib.common.gameplay.goap.condition.GOAPMutableConditionContainer;
import com.lib.common.gameplay.goap.condition.expression.GOAPExpression;
import com.lib.common.gameplay.goap.effect.GOAPEffect;
import com.lib.common.gameplay.goap.effect.GOAPEffectContainer;
import com.lib.common.gameplay.goap.effect.GOAPMutableEffectContainer;
import com.lib.common.gameplay.goap.state.GOAPBlackboard;
import com.lib.common.gameplay.goap.state.GOAPWorldState;

public abstract class GOAPAction<T> {
    private final GOAPMutableEffectContainer effects = new GOAPMutableEffectContainer();
    private final String name = this.getClass().getSimpleName();
    private final GOAPMutableConditionContainer preconditions = new GOAPMutableConditionContainer();
    protected float cost = 1.0f;

    protected final <U> void addPrecondition(TypedIdentifier<? extends U> identifier, GOAPExpression<? super U> condition) {
        this.preconditions.addCondition(new GOAPCondition<U>(identifier, condition));
    }

    protected final void addEffect(GOAPEffect<?> effect) {
        this.effects.addEffect(effect);
    }

    public abstract boolean perform(T var1, GOAPWorldState var2, GOAPBlackboard var3);

    public void onFinish(T context, GOAPWorldState worldState, GOAPBlackboard blackboard) {
    }

    public float getCost(T context, GOAPWorldState worldState) {
        return this.cost;
    }

    public GOAPEffectContainer getEffects() {
        return this.effects;
    }

    public String getName() {
        return this.name;
    }

    public GOAPConditionContainer getPreconditions() {
        return this.preconditions;
    }
}

