/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.util.spatial.block;

import com.lib.common.util.DirectionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BlockPosUtil {
    public static List<BlockPos> getNeighborsMatching(Level level, BlockPos centerPos, Predicate<BlockState> predicate) {
        ArrayList<BlockPos> matchingNeighbors = new ArrayList<BlockPos>();
        for (Direction direction : DirectionUtil.VALUES) {
            BlockPos neighborPos = centerPos.relative(direction);
            BlockState state = level.getBlockState(neighborPos);
            if (!predicate.test(state)) continue;
            matchingNeighbors.add(neighborPos);
        }
        return matchingNeighbors;
    }

    public static boolean isFireAdjacent(Level level, BlockPos blockPos) {
        return Direction.stream().anyMatch(direction -> level.getBlockState(blockPos.relative(direction)).is(BlockTags.FIRE));
    }
}

