/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.util.spatial.region;

import net.minecraft.world.level.ChunkPos;

public record RegionPos(int x, int z) {
    public static final int REGION_SIZE = 128;

    public static RegionPos fromChunkPos(ChunkPos pos) {
        return new RegionPos(pos.x >> 7, pos.z >> 7);
    }

    public static RegionPos fromChunkCoords(int chunkX, int chunkZ) {
        return new RegionPos(chunkX >> 7, chunkZ >> 7);
    }

    public ChunkPos getChunkOrigin() {
        return new ChunkPos(this.x << 7, this.z << 7);
    }

    public long toLong() {
        return (long)this.x << 32 | (long)this.z & 0xFFFFFFFFL;
    }

    public static RegionPos fromLong(long packed) {
        int x = (int)(packed >> 32);
        int z = (int)packed;
        return new RegionPos(x, z);
    }
}

