/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.util.spatial.sphere.layer;

import com.lib.common.gameplay.util.spatial.Vec3Like;
import com.lib.common.gameplay.util.spatial.sphere.layer.LayeredSphere;
import com.lib.common.gameplay.util.spatial.sphere.layer.SphereLayerDistanceTarget;

public interface SphereLayer {
    public float getMinNormalizedRadius();

    public float getMaxNormalizedRadius();

    default public boolean contains(LayeredSphere sphere, Vec3Like point) {
        double distSqr = point.distanceSquaredTo(sphere.getCenter());
        float minRadius = sphere.getRadius() * this.getMinNormalizedRadius();
        float maxRadius = sphere.getRadius() * this.getMaxNormalizedRadius();
        float minSqr = minRadius * minRadius;
        float maxSqr = maxRadius * maxRadius;
        return distSqr >= (double)minSqr && distSqr < (double)maxSqr;
    }

    default public boolean containsFromCenterToOuterEdge(LayeredSphere sphere, Vec3Like pos) {
        float outer;
        float outerSqr;
        double distSqr = pos.distanceSquaredTo(sphere.getCenter());
        return distSqr <= (double)(outerSqr = (outer = sphere.getRadius() * this.getMaxNormalizedRadius()) * outer);
    }

    default public double distanceSquaredTo(LayeredSphere sphere, Vec3Like pos, SphereLayerDistanceTarget target) {
        double distToCenterSqr = pos.distanceSquaredTo(sphere.getCenter());
        float radius = sphere.getRadius();
        double minSqr = Math.pow(radius * this.getMinNormalizedRadius(), 2.0);
        double maxSqr = Math.pow(radius * this.getMaxNormalizedRadius(), 2.0);
        return switch (target) {
            default -> throw new MatchException(null, null);
            case SphereLayerDistanceTarget.INNER_BOUNDARY -> Math.abs(distToCenterSqr - minSqr);
            case SphereLayerDistanceTarget.OUTER_BOUNDARY -> Math.abs(distToCenterSqr - maxSqr);
            case SphereLayerDistanceTarget.NEAREST_BOUNDARY -> Math.min(Math.abs(distToCenterSqr - minSqr), Math.abs(distToCenterSqr - maxSqr));
        };
    }
}

