/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.network;

import com.lib.common.network.DataContainer;
import com.lib.common.network.DataKey;
import com.lib.common.network.DataUser;
import java.util.function.Consumer;

public class DataAccessor<T> {
    private final DataContainer dataContainer;
    private final DataKey<T> dataKey;

    public DataAccessor(DataUser dataUser, DataKey<T> dataKey) {
        this(dataUser.getDataContainer(), dataKey);
    }

    public DataAccessor(DataContainer dataContainer, DataKey<T> dataKey) {
        this.dataKey = dataKey;
        this.dataContainer = dataContainer;
        dataContainer.set(dataKey, dataKey.initialValue());
    }

    public T get() {
        return this.dataContainer.get(this.dataKey);
    }

    public void reset() {
        this.dataContainer.set(this.dataKey, this.dataKey.initialValue());
    }

    public void set(T value) {
        this.dataContainer.set(this.dataKey, value);
    }

    public void onChange(Consumer<T> callback) {
        this.dataContainer.setOnChangeCallback(this.dataKey, callback);
    }

    public void onLoad(Consumer<T> callback) {
        this.dataContainer.setOnLoadCallback(this.dataKey, callback);
    }
}

