/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.registry;

import com.lib.common.network.DataKey;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class DataKeyRegistry {
    private static final Map<Integer, ResourceLocation> ID_TO_RESOURCE_LOCATION = new HashMap<Integer, ResourceLocation>();
    private static final Map<ResourceLocation, Integer> RESOURCE_LOCATION_TO_ID = new HashMap<ResourceLocation, Integer>();
    private static final Map<ResourceLocation, DataKey<?>> RESOURCE_LOCATION_TO_DATA_KEY = new HashMap();
    private static final AtomicInteger NEXT_FREE_ID = new AtomicInteger(0);

    public static <T> DataKey<T> register(ResourceLocation resourceLocation, DataKey<T> dataKey) {
        int id = NEXT_FREE_ID.getAndIncrement();
        ID_TO_RESOURCE_LOCATION.put(id, resourceLocation);
        RESOURCE_LOCATION_TO_ID.put(resourceLocation, id);
        RESOURCE_LOCATION_TO_DATA_KEY.put(resourceLocation, dataKey);
        return dataKey;
    }

    @Nullable
    public static ResourceLocation getResourceLocationOrNull(int id) {
        return ID_TO_RESOURCE_LOCATION.get(id);
    }

    @Nullable
    public static Integer getIdOrNull(ResourceLocation resourceLocation) {
        return RESOURCE_LOCATION_TO_ID.get(resourceLocation);
    }

    @Nullable
    public static DataKey<?> getDataKeyOrNull(int id) {
        ResourceLocation resourceLocation = DataKeyRegistry.getResourceLocationOrNull(id);
        return resourceLocation == null ? null : DataKeyRegistry.getDataKeyOrNull(resourceLocation);
    }

    @Nullable
    public static DataKey<?> getDataKeyOrNull(ResourceLocation resourceLocation) {
        return RESOURCE_LOCATION_TO_DATA_KEY.get(resourceLocation);
    }
}

