/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.util;

import com.avp.common.registry.AVPDeferredHolder;
import com.avp.common.registry.key.AVPDamageTypeKeys;
import com.lib.common.gameplay.entity.manager.GeneContainer;
import com.lib.common.gameplay.gene.Gene;
import com.lib.common.gameplay.gene.GeneOperationType;
import com.lib.common.gameplay.gene.Genes;
import com.lib.common.model.GeneCarrier;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;

public class GeneResistanceHurtUtil {
    public static float applyResistancesToDamage(GeneCarrier geneCarrier, DamageSource damageSource, float damage) {
        GeneContainer geneContainer = geneCarrier.getOrCreateGeneManager().getGeneContainer();
        if (damageSource.is(AVPDamageTypeKeys.ACID)) {
            return GeneResistanceHurtUtil.applyGeneResistanceToDamage(geneContainer, Genes.ACID_RESISTANCE, damage);
        }
        if (damageSource.is(DamageTypeTags.IS_FIRE)) {
            return GeneResistanceHurtUtil.applyGeneResistanceToDamage(geneContainer, Genes.FIRE_RESISTANCE, damage);
        }
        if (damageSource.is(DamageTypes.FREEZE)) {
            return GeneResistanceHurtUtil.applyGeneResistanceToDamage(geneContainer, Genes.COLD_RESISTANCE, damage);
        }
        return damage;
    }

    private static float applyGeneResistanceToDamage(GeneContainer geneContainer, AVPDeferredHolder<Gene> gene, float damage) {
        double percentageResistance = geneContainer.getActiveGeneMap().getValue(gene, GeneOperationType.MULTIPLICATIVE);
        double damageResistance = geneContainer.getActiveGeneMap().getValue(gene, GeneOperationType.ADDITIVE);
        double modifiedDamage = Math.max((double)damage - percentageResistance * (double)damage - damageResistance, 0.0);
        return (float)modifiedDamage;
    }
}

