/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.util.codec;

import com.just.codec.Codec;
import com.just.codec.schema.CodecSchema;
import com.just.core.functional.result.Result;
import com.lib.common.util.codec.schema.CodecSchemas;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import net.minecraft.nbt.NbtOps;

public class CodecUtil {
    private static final Map<CodecSchema<?>, DynamicOps<?>> CODEC_SCHEMA_TO_DYNAMIC_OPS = Map.of(CodecSchemas.NBT, NbtOps.INSTANCE);
    private static final Map<DynamicOps<?>, CodecSchema<?>> DYNAMIC_OPS_TO_CODEC_SCHEMA = Map.of(NbtOps.INSTANCE, CodecSchemas.NBT);

    public static <A> Codec<A> adapt(final com.mojang.serialization.Codec<A> codec) {
        return new Codec<A>(){

            public <T> T encode(CodecSchema<T> codecSchema, A value) {
                DynamicOps<?> ops = CODEC_SCHEMA_TO_DYNAMIC_OPS.get(codecSchema);
                DataResult result = codec.encodeStart(ops, value);
                return result.isSuccess() ? (T)result.result().get() : null;
            }

            public <T> Result<A, T> decode(CodecSchema<T> codecSchema, T input) {
                DynamicOps<?> ops = CODEC_SCHEMA_TO_DYNAMIC_OPS.get(codecSchema);
                DataResult result = codec.decode(ops, input);
                return result.isSuccess() ? Result.ok((Object)((Pair)result.result().get()).getFirst()) : Result.err(input);
            }
        };
    }

    public static <A> com.mojang.serialization.Codec<A> adapt(final Codec<A> codec) {
        return new com.mojang.serialization.Codec<A>(){

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
                CodecSchema<?> codecSchema = DYNAMIC_OPS_TO_CODEC_SCHEMA.get(ops);
                Result result = codec.decode(codecSchema, input);
                return result.isOk() ? DataResult.success((Object)new Pair(result.unwrap(), input)) : DataResult.error(() -> "");
            }

            public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
                CodecSchema<?> codecSchema = DYNAMIC_OPS_TO_CODEC_SCHEMA.get(ops);
                return DataResult.success((Object)codec.encode(codecSchema, input));
            }
        };
    }
}

