/*
 * Decompiled with CFR 0.152.
 */
package com.predator.common.gameplay.block.entity;

import com.avp.AVP;
import com.avp.common.registry.init.AVPBlockEntityTypes;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.util.AVPPredicates;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class TripMineBlockEntity
extends BlockEntity {
    private boolean triggered = false;
    private int countdown = 0;

    public TripMineBlockEntity(BlockPos pos, BlockState blockState) {
        super(AVPBlockEntityTypes.TRIP_MINE.get(), pos, blockState);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TripMineBlockEntity tripMineBlockEntity) {
        if (level.isClientSide) {
            return;
        }
        AABB detectionArea = new AABB(blockPos).inflate(AVP.config.blockConfigs.TRIP_MINE_SEARCH_RADIUS);
        List entities = level.getEntitiesOfClass(LivingEntity.class, detectionArea, entity -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !AVPPredicates.IS_IMMORTAL.test((LivingEntity)player);
            }
            return entity.getType().is(AVPEntityTypeTags.PREDATORS);
        });
        if (!entities.isEmpty()) {
            if (!tripMineBlockEntity.isTriggered()) {
                tripMineBlockEntity.setTriggered(true);
                tripMineBlockEntity.setCountdown(100);
            } else {
                tripMineBlockEntity.decrementCountdown();
                if (tripMineBlockEntity.getCountdown() % 20 == 0) {
                    level.playSound(null, blockPos, SoundEvents.METAL_PRESSURE_PLATE_CLICK_ON, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
                }
                if (tripMineBlockEntity.getCountdown() <= 0) {
                    level.explode(null, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, 4.0f, Level.ExplosionInteraction.TNT);
                    level.removeBlock(blockPos, false);
                }
            }
        } else if (tripMineBlockEntity.isTriggered()) {
            tripMineBlockEntity.setTriggered(false);
            tripMineBlockEntity.setCountdown(0);
        }
    }

    public boolean isTriggered() {
        return this.triggered;
    }

    public void setTriggered(boolean triggered) {
        this.triggered = triggered;
    }

    public int getCountdown() {
        return this.countdown;
    }

    public void setCountdown(int countdown) {
        this.countdown = countdown;
    }

    public void decrementCountdown() {
        if (this.countdown > 0) {
            --this.countdown;
        }
    }
}

