/*
 * Decompiled with CFR 0.152.
 */
package com.predator.common.gameplay.entity.living.yautja;

import com.avp.AVP;
import com.avp.common.config.AVPConfig;
import com.avp.common.gameplay.ai.goal.StrollAroundInWaterGoal;
import com.avp.common.gameplay.ai.goal.combat.DelayedAttackGoal;
import com.avp.common.gameplay.ai.goal.combat.UseItemGoal;
import com.avp.common.registry.init.item.AVPItems;
import com.lib.common.network.DataUser;
import com.predator.common.gameplay.entity.living.yautja.YautjaAnimationDispatcher;
import com.predator.common.gameplay.entity.living.yautja.manager.YautjaNavigationManager;
import com.predator.common.gameplay.entity.living.yautja.util.YautjaPredicates;
import com.predator.common.registry.init.item.PredatorArmorItems;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Yautja
extends Monster
implements DataUser {
    private final YautjaAnimationDispatcher animationDispatcher = new YautjaAnimationDispatcher(this);
    private final YautjaNavigationManager navigationManager = new YautjaNavigationManager(this, this.moveControl);

    public Yautja(EntityType<? extends Yautja> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createYautjaAttributes() {
        return Yautja.applyFrom(AVP.config.statsConfigs.YAUTJA_STATS, Monster.createMonsterAttributes());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new DelayedAttackGoal((PathfinderMob)this, 1.0, true, 5, () -> {}));
        this.goalSelector.addGoal(1, (Goal)new UseItemGoal((PathfinderMob)this, () -> {}));
        this.goalSelector.addGoal(7, (Goal)new StrollAroundInWaterGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{Yautja.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false, target -> YautjaPredicates.isThreateningTarget(this, target)));
    }

    public void tick() {
        super.tick();
        this.checkMask();
        if (!this.level().isClientSide && (this.getVehicle() instanceof Boat || this.getVehicle() instanceof Minecart)) {
            this.stopRiding();
        }
    }

    public void checkMask() {
        boolean overHalfHealth;
        if (this.level().isClientSide || !this.hasMask()) {
            return;
        }
        boolean bl = overHalfHealth = this.getHealth() > this.getMaxHealth() / 2.0f;
        if (!overHalfHealth) {
            this.setItemSlot(EquipmentSlot.HEAD, ItemStack.EMPTY);
        }
    }

    public boolean hasMask() {
        return this.getItemBySlot(EquipmentSlot.HEAD).getItem() == PredatorArmorItems.JUNGLE_PREDATOR_HELMET.get();
    }

    public boolean startRiding(@NotNull Entity entity, boolean force) {
        if (entity instanceof Boat || entity instanceof Minecart) {
            return false;
        }
        return super.startRiding(entity, force);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor serverLevelAccessor, @NotNull DifficultyInstance difficultyInstance, @NotNull MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)PredatorArmorItems.JUNGLE_PREDATOR_HELMET.get()));
        this.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)PredatorArmorItems.JUNGLE_PREDATOR_CHESTPLATE.get()));
        this.setItemSlot(EquipmentSlot.LEGS, new ItemStack((ItemLike)PredatorArmorItems.JUNGLE_PREDATOR_LEGGINGS.get()));
        this.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)PredatorArmorItems.JUNGLE_PREDATOR_BOOTS.get()));
        if (this.random.nextDouble() <= 0.5) {
            if (this.random.nextDouble() <= 0.7) {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)AVPItems.SHURIKEN.get()));
            } else {
                this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)AVPItems.SMART_DISC.get()));
            }
        }
        return super.finalizeSpawn(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
    }

    public static AttributeSupplier.Builder applyFrom(AVPConfig.StatsConfigs.AdvancedStats config, AttributeSupplier.Builder builder) {
        builder.add(Attributes.ARMOR, (double)config.armor);
        builder.add(Attributes.ARMOR_TOUGHNESS, (double)config.armorToughness);
        builder.add(Attributes.ATTACK_DAMAGE, (double)config.attackDamage);
        builder.add(Attributes.FOLLOW_RANGE, (double)config.followRange);
        builder.add(Attributes.KNOCKBACK_RESISTANCE, (double)config.knockbackResistance);
        builder.add(Attributes.MAX_HEALTH, (double)config.health);
        builder.add(Attributes.MOVEMENT_SPEED, (double)config.moveSpeed);
        return builder;
    }

    public void setMoveControl(MoveControl moveControl) {
        this.moveControl = moveControl;
    }

    public void setNavigation(PathNavigation navigation) {
        this.navigation = navigation;
    }

    public void updateSwimming() {
        if (!this.level().isClientSide) {
            if (this.isEffectiveAi() && this.isUnderWater()) {
                this.navigationManager.switchToWater(this, 4, this.goalSelector);
                this.setSwimming(true);
            } else {
                this.navigationManager.switchToGround(this, 4, this.goalSelector);
                this.setSwimming(false);
            }
        }
    }

    public void travel(@NotNull Vec3 vec3) {
        if (this.isControlledByLocalInstance() && this.isUnderWater()) {
            this.moveRelative(0.01f, vec3);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.8));
        } else {
            super.travel(vec3);
        }
    }
}

