/*
 * Decompiled with CFR 0.152.
 */
package com.predator.common.gameplay.entity.living.yautja.manager;

import com.avp.common.gameplay.ai.goal.WaterMoveControl;
import com.avp.common.gameplay.ai.goal.combat.UseItemGoal;
import com.predator.common.gameplay.entity.living.yautja.Yautja;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.pathfinder.PathType;

public class YautjaNavigationManager {
    private final GroundPathNavigation groundNavigation;
    private final MoveControl groundMoveControl;
    private final WaterBoundPathNavigation waterNavigation;
    private final WaterMoveControl waterMoveControl;
    private final Goal groundAttackGoal;
    private final Goal waterAttackGoal;

    public YautjaNavigationManager(Yautja yautja, MoveControl moveControl) {
        this.groundAttackGoal = new UseItemGoal((PathfinderMob)yautja, () -> {});
        this.groundMoveControl = moveControl;
        this.groundNavigation = new GroundPathNavigation((Mob)yautja, yautja.level());
        yautja.setPathfindingMalus(PathType.WATER, 0.0f);
        this.waterAttackGoal = new UseItemGoal((PathfinderMob)yautja, () -> {});
        this.waterMoveControl = new WaterMoveControl((PathfinderMob)yautja);
        this.waterNavigation = new WaterBoundPathNavigation((Mob)yautja, yautja.level());
    }

    public void switchToGround(Yautja yautja, int priority, GoalSelector goalSelector) {
        goalSelector.removeGoal(this.waterAttackGoal);
        goalSelector.addGoal(priority, this.groundAttackGoal);
        yautja.setMoveControl(this.groundMoveControl);
        yautja.setNavigation((PathNavigation)this.groundNavigation);
    }

    public void switchToWater(Yautja yautja, int priority, GoalSelector goalSelector) {
        goalSelector.removeGoal(this.groundAttackGoal);
        goalSelector.addGoal(priority, this.waterAttackGoal);
        yautja.setMoveControl(this.waterMoveControl);
        yautja.setNavigation((PathNavigation)this.waterNavigation);
    }
}

