/*
 * Decompiled with CFR 0.152.
 */
package com.predator.common.gameplay.entity.projectile;

import com.avp.common.registry.init.item.AVPItems;
import com.avp.common.util.ItemGoalUtil;
import com.avp.server.BlockBreakProgressManager;
import com.predator.common.registry.init.PredatorEntityTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class SmartDiscProjectile
extends ThrowableItemProjectile {
    private boolean dealtDamage;

    public SmartDiscProjectile(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public SmartDiscProjectile(Level level, LivingEntity livingEntity) {
        super(PredatorEntityTypes.SMART_DISC.get(), livingEntity, level);
    }

    @NotNull
    protected Item getDefaultItem() {
        return AVPItems.SMART_DISC.get();
    }

    public void tick() {
        super.tick();
        if (this.getOwner() == null) {
            this.kill();
        }
        if (this.tickCount > 300) {
            this.kill();
        }
        if (!this.dealtDamage) {
            ItemGoalUtil.trackToLivingEntity((Projectile)this, 0.5, false);
        } else {
            ItemGoalUtil.trackToOwnerEntity((Projectile)this);
        }
    }

    protected void onHitBlock(@NotNull BlockHitResult result) {
        if (!this.level().isClientSide) {
            BlockBreakProgressManager.damage(this.level(), result.getBlockPos(), 2.0f);
            this.dealtDamage = true;
        }
        super.onHitBlock(result);
    }

    protected void onHitEntity(@NotNull EntityHitResult result) {
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.getOwner() != null && livingEntity != this.getOwner()) {
                livingEntity.hurt(this.damageSources().thrown(this.getOwner(), (Entity)livingEntity), 5.0f);
                this.dealtDamage = true;
            }
        }
        super.onHitEntity(result);
    }
}

