/*
 * Decompiled with CFR 0.152.
 */
package com.predator.common.gameplay.item;

import com.predator.common.gameplay.entity.projectile.ShurikenProjectile;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ShurikenItem
extends Item {
    public ShurikenItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return 72000;
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity, int timeCharged) {
        Player player;
        int i = this.getUseDuration(stack, livingEntity) - timeCharged;
        float powerForTime = ShurikenItem.getPowerForTime(i);
        if ((double)powerForTime > 0.1 && livingEntity instanceof Player && !(player = (Player)livingEntity).getCooldowns().isOnCooldown((Item)this)) {
            player.getCooldowns().addCooldown((Item)this, 5);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.TRIDENT_THROW, SoundSource.PLAYERS, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
            if (!level.isClientSide) {
                ShurikenProjectile shurikenItemEntity = new ShurikenProjectile(level, (LivingEntity)player);
                shurikenItemEntity.setItem(stack);
                shurikenItemEntity.setOwner((Entity)player);
                shurikenItemEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, powerForTime * 6.5f, 1.0f);
                level.addFreshEntity((Entity)shurikenItemEntity);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
        }
        super.releaseUsing(stack, level, livingEntity, timeCharged);
    }

    public static float getPowerForTime(int charge) {
        float normalizedCharge = (float)charge / 20.0f;
        if ((normalizedCharge = (normalizedCharge * normalizedCharge + normalizedCharge * 2.0f) / 3.0f) > 1.0f) {
            normalizedCharge = 1.0f;
        }
        return normalizedCharge;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }
}

