/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.animation.controller;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Collection;
import java.util.Map;
import mod.azure.azurelib.common.animation.controller.AzAnimationController;
import org.jetbrains.annotations.Nullable;

public class AzAnimationControllerContainer<T> {
    private final Map<String, AzAnimationController<T>> animationControllersByName = new Object2ObjectArrayMap();

    @SafeVarargs
    public final void add(AzAnimationController<T> controller, AzAnimationController<T> ... controllers) {
        this.animationControllersByName.put(controller.name(), controller);
        for (AzAnimationController<T> extraController : controllers) {
            this.animationControllersByName.put(extraController.name(), extraController);
        }
    }

    @Nullable
    public AzAnimationController<T> getOrNull(String controllerName) {
        return this.animationControllersByName.get(controllerName);
    }

    public Collection<AzAnimationController<T>> getAll() {
        return this.animationControllersByName.values();
    }
}

