/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.animation.easing.bedrock_easings;

import it.unimi.dsi.fastutil.doubles.Double2DoubleFunction;
import java.util.List;
import mod.azure.azurelib.common.animation.controller.keyframe.AzAnimationPoint;
import mod.azure.azurelib.common.animation.easing.AzEasingType;
import mod.azure.azurelib.common.animation.easing.AzEasingUtil;
import mod.azure.azurelib.common.animation.easing.bedrock_easings.CubicBezierCurve;
import mod.azure.azurelib.core.math.IValue;
import net.minecraft.util.Mth;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public abstract class BezierEasing
implements AzEasingType {
    private static final double DEFAULT_RIGHT_TIME = 0.1;
    private static final double DEFAULT_LEFT_TIME = -0.1;
    private static final int CURVE_RESOLUTION = 200;
    private static final double TICKS_PER_SECOND = 20.0;

    @Override
    public Double2DoubleFunction buildTransformer(Double value) {
        return AzEasingUtil.easeIn(AzEasingUtil::linear);
    }

    @Override
    public double apply(AzAnimationPoint animationPoint, Double easingValue, double lerpValue) {
        double leftTime;
        List<?> easingArgs = animationPoint.keyframe().easingArgs();
        if (easingArgs.isEmpty()) {
            return this.handleNoEasingArgs(animationPoint, easingValue, lerpValue);
        }
        boolean easingBefore = this.isEasingBefore();
        double rightValue = easingBefore ? 0.0 : ((IValue)easingArgs.getFirst()).get();
        double rightTime = easingBefore ? 0.1 : ((IValue)easingArgs.get(1)).get();
        double leftValue = easingBefore ? ((IValue)easingArgs.getFirst()).get() : 0.0;
        double d = leftTime = easingBefore ? ((IValue)easingArgs.get(1)).get() : -0.1;
        if (easingArgs.size() > 3) {
            rightValue = ((IValue)easingArgs.get(2)).get();
            rightTime = ((IValue)easingArgs.get(3)).get();
        }
        leftValue = Math.toRadians(leftValue);
        rightValue = Math.toRadians(rightValue);
        double normalizedTransitionDuration = animationPoint.transitionLength() / 20.0;
        double clampedRightTime = Math.clamp(rightTime, 0.0, normalizedTransitionDuration);
        double clampedLeftTime = Math.clamp(leftTime, -normalizedTransitionDuration, 0.0);
        CubicBezierCurve curve = this.buildBezierCurve(animationPoint, clampedLeftTime, clampedRightTime, leftValue, rightValue, normalizedTransitionDuration);
        double time = normalizedTransitionDuration * lerpValue;
        List<Vector2d> points = curve.getPoints(200);
        Vector2d[] closestPoints = this.findClosestPoints(points, time);
        return Mth.lerp((double)Math.clamp(Mth.lerp((double)time, (double)closestPoints[0].x, (double)closestPoints[1].x), 0.0, 1.0), (double)closestPoints[0].y, (double)closestPoints[1].y);
    }

    public abstract boolean isEasingBefore();

    private double handleNoEasingArgs(AzAnimationPoint animationPoint, Double easingValue, double lerpValue) {
        Double2DoubleFunction transformer = this.buildTransformer(easingValue);
        return Mth.lerp((double)((Double)transformer.apply((Object)lerpValue)), (double)animationPoint.animationStartValue(), (double)animationPoint.animationEndValue());
    }

    private CubicBezierCurve buildBezierCurve(AzAnimationPoint animationPoint, double clampedLeftTime, double clampedRightTime, double leftValue, double rightValue, double normalizedTransitionDuration) {
        return new CubicBezierCurve(new Vector2d(0.0, animationPoint.animationStartValue()), new Vector2d(clampedRightTime, animationPoint.animationStartValue() + rightValue), new Vector2d(clampedLeftTime + normalizedTransitionDuration, animationPoint.animationEndValue() + leftValue), new Vector2d(normalizedTransitionDuration, animationPoint.animationEndValue()));
    }

    private Vector2d[] findClosestPoints(List<Vector2d> points, double time) {
        Vector2d closest = new Vector2d();
        Vector2d secondClosest = new Vector2d();
        double closestDiff = Double.POSITIVE_INFINITY;
        double secondClosestDiff = Double.POSITIVE_INFINITY;
        for (Vector2d point : points) {
            double diff = Math.abs(point.x - time);
            if (diff < closestDiff) {
                secondClosest.set((Vector2dc)closest);
                secondClosestDiff = closestDiff;
                closest.set((Vector2dc)point);
                closestDiff = diff;
                continue;
            }
            if (!(diff < secondClosestDiff)) continue;
            secondClosest.set((Vector2dc)point);
            secondClosestDiff = diff;
        }
        return new Vector2d[]{closest, secondClosest};
    }
}

