/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.animation.property.codec;

import mod.azure.azurelib.common.animation.easing.AzEasingType;
import mod.azure.azurelib.common.animation.easing.AzEasingTypeRegistry;
import mod.azure.azurelib.common.animation.easing.AzEasingTypes;
import mod.azure.azurelib.common.animation.property.AzAnimationProperties;
import net.minecraft.class_2540;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public class AzAnimationPropertiesCodec
implements class_9139<class_2540, AzAnimationProperties> {
    @NotNull
    public AzAnimationProperties decode(class_2540 buf) {
        int propertyLength = buf.readByte();
        AzAnimationProperties properties = AzAnimationProperties.EMPTY;
        block9: for (int i = 0; i < propertyLength; ++i) {
            byte code = buf.readByte();
            switch (code) {
                case 0: {
                    properties = properties.withAnimationSpeed(buf.readDouble());
                    continue block9;
                }
                case 1: {
                    properties.withTransitionLength(buf.readFloat());
                    continue block9;
                }
                case 2: {
                    AzEasingType easingType = AzEasingTypeRegistry.getOrDefault(buf.method_19772(), AzEasingTypes.NONE);
                    properties = properties.withEasingType(easingType);
                    continue block9;
                }
                case 3: {
                    properties = properties.withStartTickOffset(buf.readDouble());
                    continue block9;
                }
                case 4: {
                    properties = properties.withFreezeTickOffset(buf.readDouble());
                    continue block9;
                }
                case 5: {
                    properties = properties.withRepeatXTimes(buf.readDouble());
                    continue block9;
                }
                case 6: {
                    properties = properties.withShouldReverse(buf.readBoolean());
                }
            }
        }
        return properties;
    }

    public void encode(class_2540 buf, AzAnimationProperties properties) {
        int propertyLength = 0;
        propertyLength += properties.hasAnimationSpeed() ? 1 : 0;
        propertyLength += properties.hasTransitionLength() ? 1 : 0;
        propertyLength += properties.hasEasingType() ? 1 : 0;
        propertyLength += properties.hasStartTickOffset() ? 1 : 0;
        propertyLength += properties.hasFreezeTickOffset() ? 1 : 0;
        propertyLength += properties.hasRepeatXTimes() ? 1 : 0;
        buf.method_52997(propertyLength += properties.hasReversing() ? 1 : 0);
        if (properties.hasAnimationSpeed()) {
            buf.method_52997(0);
            buf.method_52940(properties.animationSpeed());
        }
        if (properties.hasTransitionLength()) {
            buf.method_52997(1);
            buf.method_52941(properties.transitionLength());
        }
        if (properties.hasEasingType()) {
            buf.method_52997(2);
            buf.method_10814(properties.easingType().name());
        }
        if (properties.hasStartTickOffset()) {
            buf.method_52997(3);
            buf.method_52940(properties.startTickOffset());
        }
        if (properties.hasFreezeTickOffset()) {
            buf.method_52997(4);
            buf.method_52940(properties.freezeTickOffset());
        }
        if (properties.hasRepeatXTimes()) {
            buf.method_52997(5);
            buf.method_52940(properties.repeatXTimes());
        }
        if (properties.hasReversing()) {
            buf.method_52997(6);
            buf.method_52964(properties.isReversing());
        }
    }
}

