/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.cache;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public abstract class AzResourceCache {
    public static final Set<String> EXCLUDED_NAMESPACES = ObjectOpenHashSet.of((Object[])new String[]{"moreplayermodels", "customnpcs", "creeperoverhaul", "geckolib", "gunsrpg", "born_in_chaos_v1", "neoforge", "brutality", "crazythings"});

    protected final <T> CompletableFuture<Void> loadResources(Executor executor, class_3300 resourceManager, String type, Function<class_2960, T> loader, BiConsumer<class_2960, T> map) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> resourceManager.method_14488(type, fileName -> fileName.toString().endsWith(".json")), executor).thenApplyAsync(resources -> {
            Object2ObjectOpenHashMap tasks = new Object2ObjectOpenHashMap();
            for (class_2960 resource : resources.keySet()) {
                tasks.put((Object)resource, CompletableFuture.supplyAsync(() -> loader.apply(resource), executor));
            }
            return tasks;
        }, executor)).thenAcceptAsync(tasks -> {
            for (Map.Entry entry : tasks.entrySet()) {
                if (EXCLUDED_NAMESPACES.contains(((class_2960)entry.getKey()).method_12836().toLowerCase(Locale.ROOT))) continue;
                map.accept((class_2960)entry.getKey(), ((CompletableFuture)entry.getValue()).join());
            }
        }, executor);
    }
}

