/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.render;

import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import mod.azure.azurelib.common.model.AzBakedModel;
import mod.azure.azurelib.common.render.AzRendererPipeline;
import mod.azure.azurelib.common.util.client.RenderUtils;
import mod.azure.azurelib.core.object.Color;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import org.jetbrains.annotations.Nullable;

public abstract class AzRendererPipelineContext<K, T> {
    public class_2960 textureOverride;
    private final AzRendererPipeline<K, T> rendererPipeline;
    protected T animatable;
    @Nullable
    protected class_1297 currentEntity;
    private AzBakedModel bakedModel;
    private class_4597 multiBufferSource;
    private int packedLight;
    private int packedOverlay;
    private float partialTick;
    private class_4587 poseStack;
    private int renderColor;
    @Nullable
    private class_1921 renderType;
    private class_4588 vertexConsumer;
    protected static final Map<class_2960, IntIntPair> TEXTURE_DIMENSIONS_CACHE = new Object2ObjectOpenHashMap();

    protected AzRendererPipelineContext(AzRendererPipeline<K, T> rendererPipeline) {
        this.rendererPipeline = rendererPipeline;
    }

    public void populate(T animatable, AzBakedModel bakedModel, class_4597 multiBufferSource, int packedLight, float partialTick, class_4587 poseStack, class_1921 renderType, class_4588 vertexConsumer) {
        this.animatable = animatable;
        this.bakedModel = bakedModel;
        this.multiBufferSource = multiBufferSource;
        this.packedLight = packedLight;
        this.packedOverlay = this.getPackedOverlay(animatable, 0.0f, partialTick);
        this.partialTick = partialTick;
        this.poseStack = poseStack;
        this.renderType = renderType;
        this.vertexConsumer = vertexConsumer;
        this.renderColor = this.getRenderColor(animatable, partialTick, packedLight).argbInt();
        if (renderType == null) {
            class_2960 textureLocation = this.rendererPipeline.config().textureLocation(this.currentEntity, animatable);
            this.renderType = this.getDefaultRenderType(animatable, textureLocation, multiBufferSource, partialTick, this.rendererPipeline.config().getRenderType(this.currentEntity, animatable), this.rendererPipeline.config().alpha(animatable));
        }
        if (vertexConsumer == null && this.renderType != null) {
            this.vertexConsumer = multiBufferSource.getBuffer(this.renderType);
        }
    }

    public abstract class_1921 getDefaultRenderType(T var1, class_2960 var2, @Nullable class_4597 var3, float var4, class_1921 var5, float var6);

    protected Color getRenderColor(T animatable, float partialTick, int packedLight) {
        return Color.WHITE;
    }

    protected int getPackedOverlay(T animatable, float u, float partialTick) {
        return class_4608.field_21444;
    }

    public AzRendererPipeline<K, T> rendererPipeline() {
        return this.rendererPipeline;
    }

    public T animatable() {
        return this.animatable;
    }

    public void setCurrentEntity(class_1297 currentEntity) {
        this.currentEntity = currentEntity;
    }

    @Nullable
    public class_1297 currentEntity() {
        return this.currentEntity;
    }

    public AzBakedModel bakedModel() {
        return this.bakedModel;
    }

    public class_4597 multiBufferSource() {
        return this.multiBufferSource;
    }

    public int packedLight() {
        return this.packedLight;
    }

    public void setPackedLight(int packedLight) {
        this.packedLight = packedLight;
    }

    public int packedOverlay() {
        return this.packedOverlay;
    }

    public void setPackedOverlay(int packedOverlay) {
        this.packedOverlay = packedOverlay;
    }

    public float partialTick() {
        return this.partialTick;
    }

    public class_4587 poseStack() {
        return this.poseStack;
    }

    public int renderColor() {
        return this.renderColor;
    }

    public void setRenderColor(int renderColor) {
        this.renderColor = renderColor;
    }

    @Nullable
    public class_1921 renderType() {
        return this.renderType;
    }

    public void setRenderType(@Nullable class_1921 renderType) {
        this.renderType = renderType;
    }

    public class_4588 vertexConsumer() {
        return this.vertexConsumer;
    }

    public void setVertexConsumer(class_4588 vertexConsumer) {
        this.vertexConsumer = vertexConsumer;
    }

    public void setTextureOverride(class_2960 textureOverride) {
        this.textureOverride = textureOverride;
    }

    public class_2960 getTextureOverride() {
        return this.textureOverride;
    }

    public IntIntPair computeTextureSize(class_2960 texture) {
        return TEXTURE_DIMENSIONS_CACHE.computeIfAbsent(texture, RenderUtils::getTextureDimensions);
    }
}

