/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.fabric.platform;

import mod.azure.azurelib.common.network.AbstractPacket;
import mod.azure.azurelib.common.network.packet.SendConfigDataPacket;
import mod.azure.azurelib.common.platform.Services;
import mod.azure.azurelib.common.platform.services.AzureLibNetwork;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9139;

public class FabricAzureLibNetwork
implements AzureLibNetwork {
    public static <B extends class_2540, P extends AbstractPacket> void registerPacket(class_8710.class_9154<P> packetType, class_9139<B, P> codec) {
        PayloadTypeRegistry.playS2C().register(packetType, codec);
        ClientPlayNetworking.registerGlobalReceiver(packetType, (packet, context) -> packet.handle());
    }

    @Override
    public <B extends class_2540, P extends AbstractPacket> void registerPacketInternal(class_8710.class_9154<P> payloadType, class_9139<B, P> codec, boolean isClientBound) {
        if (isClientBound) {
            if (Services.PLATFORM.isEnvironmentClient()) {
                FabricAzureLibNetwork.registerPacket(payloadType, codec);
            }
        } else {
            PayloadTypeRegistry.playC2S().register(payloadType, codec);
            ServerPlayNetworking.registerGlobalReceiver(payloadType, (packet, context) -> packet.handle());
        }
    }

    public class_2540 createFriendlyByteBuf() {
        return PacketByteBufs.create();
    }

    @Override
    public void sendToTrackingEntityAndSelf(AbstractPacket packet, class_1297 entityToTrack) {
        if (entityToTrack instanceof class_3222) {
            class_3222 pl = (class_3222)entityToTrack;
            this.sendToPlayer(packet, pl);
        }
        for (class_3222 player : PlayerLookup.tracking((class_1297)entityToTrack)) {
            this.sendToPlayer(packet, player);
        }
    }

    @Override
    public void sendToEntitiesTrackingChunk(AbstractPacket packet, class_3218 level, class_2338 blockPos) {
        for (class_3222 player : PlayerLookup.tracking((class_3218)level, (class_2338)blockPos)) {
            this.sendToPlayer(packet, player);
        }
    }

    @Override
    public void sendToPlayer(AbstractPacket packet, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
    }

    @Override
    public void sendClientPacket(class_3222 player, String id) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new SendConfigDataPacket(id));
    }
}

