/*
 * Decompiled with CFR 0.152.
 */
package com.alien.client.render;

import com.alien.common.model.alien.variant.AlienVariant;
import com.avp.AVPResources;
import java.util.function.Function;
import net.minecraft.class_1921;
import net.minecraft.class_2960;

public class AlienRenderResourceCache {
    private static final int ROYAL_FLAG = 1;
    private final String baseName;
    private final Function<class_2960, class_1921> renderTypeFunction;
    private final class_2960[] modelLocations;
    private final class_2960[] textureLocations;
    private final class_1921[] renderTypes;

    public AlienRenderResourceCache(String baseName, Function<class_2960, class_1921> renderTypeFunction) {
        this.baseName = baseName;
        this.renderTypeFunction = renderTypeFunction;
        int size = AlienVariant.VALUES.length * 2;
        this.modelLocations = new class_2960[size];
        this.textureLocations = new class_2960[size];
        this.renderTypes = new class_1921[size];
    }

    public class_2960 getOrCreateModelLocationForVariant(AlienVariant variant) {
        return this.getOrCreateModelLocationForVariant(variant, false);
    }

    public class_2960 getOrCreateModelLocationForVariant(AlienVariant variant, boolean isRoyal) {
        int index = this.getIndex(variant, isRoyal);
        class_2960 modelLocation = this.modelLocations[index];
        if (modelLocation == null) {
            this.modelLocations[index] = modelLocation = AVPResources.entityGeoModelLocation(this.getResourceName(variant, isRoyal));
        }
        return modelLocation;
    }

    public class_2960 getOrCreateTextureLocationForVariant(AlienVariant variant) {
        return this.getOrCreateTextureLocationForVariant(variant, false);
    }

    public class_2960 getOrCreateTextureLocationForVariant(AlienVariant variant, boolean isRoyal) {
        int index = this.getIndex(variant, isRoyal);
        class_2960 textureLocation = this.textureLocations[index];
        if (textureLocation == null) {
            this.textureLocations[index] = textureLocation = AVPResources.entityTextureLocation(this.getResourceName(variant, isRoyal));
        }
        return textureLocation;
    }

    public class_1921 getOrCreateRenderTypeForVariant(AlienVariant variant) {
        return this.getOrCreateRenderTypeForVariant(variant, false);
    }

    public class_1921 getOrCreateRenderTypeForVariant(AlienVariant variant, boolean isRoyal) {
        int index = this.getIndex(variant, isRoyal);
        class_1921 renderType = this.renderTypes[index];
        if (renderType == null) {
            class_2960 texLoc = this.getOrCreateTextureLocationForVariant(variant, isRoyal);
            this.renderTypes[index] = renderType = this.renderTypeFunction.apply(texLoc);
        }
        return renderType;
    }

    private String getResourceName(AlienVariant alienVariant, boolean isRoyal) {
        return this.getPrefixForRoyalResourceLocation(isRoyal) + this.getPrefixForVariantResourceLocation(alienVariant) + this.baseName;
    }

    public String getPrefixForRoyalResourceLocation(boolean isRoyal) {
        return isRoyal ? "royal_" : "";
    }

    public String getPrefixForVariantResourceLocation(AlienVariant alienVariant) {
        return switch (alienVariant) {
            default -> throw new MatchException(null, null);
            case AlienVariant.NORMAL -> "";
            case AlienVariant.NETHER -> "nether_";
            case AlienVariant.ABERRANT -> "aberrant_";
            case AlienVariant.IRRADIATED -> "irradiated_";
        };
    }

    private int getIndex(AlienVariant variant, boolean isRoyal) {
        return variant.ordinal() << 1 | (isRoyal ? 1 : 0);
    }
}

