/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.ai;

import com.alien.common.gameplay.entity.living.alien.ovomorph.Ovomorph;
import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.avp.common.registry.init.AVPSoundEvents;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1352;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3419;

public class DropOffEggGoal<T extends Xenomorph>
extends class_1352 {
    private static final List<class_2338> EGG_GRID_POS_OFFSETS = DropOffEggGoal.generateSpiralOffsets(16);
    private final T eggCarryingXenomorph;
    private final Set<class_2338> failedEggSpots;
    private class_2338 freeEggPos;
    private class_11 pathToFreeEggPos;

    public DropOffEggGoal(T eggCarryingXenomorph) {
        this.eggCarryingXenomorph = eggCarryingXenomorph;
        this.failedEggSpots = new HashSet<class_2338>();
    }

    public boolean method_6264() {
        boolean hasAccessibleFreeEggPos;
        if (this.isUnableToMoveOvomorph()) {
            return false;
        }
        this.freeEggPos = this.findFreeEggSpot(this.eggCarryingXenomorph.method_37908(), this.eggCarryingXenomorph.method_24515(), pos -> {
            class_2680 state = this.eggCarryingXenomorph.method_37908().method_8320(pos);
            return state.method_26168((class_1922)this.eggCarryingXenomorph.method_37908(), pos, this.eggCarryingXenomorph);
        }).orElse(null);
        if (this.freeEggPos != null) {
            this.pathToFreeEggPos = this.eggCarryingXenomorph.method_5942().method_6348(this.freeEggPos, 0);
            if (this.pathToFreeEggPos != null) {
                this.eggCarryingXenomorph.method_5942().method_6334(this.pathToFreeEggPos, 0.5);
            }
        }
        boolean bl = hasAccessibleFreeEggPos = this.freeEggPos != null && this.pathToFreeEggPos != null;
        if (!hasAccessibleFreeEggPos) {
            this.getPassengerOvomorphs().forEach(class_1297::method_31472);
        }
        return hasAccessibleFreeEggPos;
    }

    public boolean method_6266() {
        return this.freeEggPos != null && this.pathToFreeEggPos != null && !this.pathToFreeEggPos.method_46() && this.pathToFreeEggPos.method_21655() && !this.isUnableToMoveOvomorph();
    }

    public void method_6269() {
        if (this.pathToFreeEggPos != null) {
            this.eggCarryingXenomorph.method_5942().method_6334(this.pathToFreeEggPos, 0.5);
        }
    }

    public void method_6268() {
        if (this.freeEggPos == null || this.pathToFreeEggPos == null || !this.pathToFreeEggPos.method_21655()) {
            this.freeEggPos = null;
            this.pathToFreeEggPos = null;
            return;
        }
        this.eggCarryingXenomorph.method_5942().method_6334(this.pathToFreeEggPos, 0.5);
        if (this.eggCarryingXenomorph.method_5707(this.freeEggPos.method_46558()) <= 4.0) {
            class_243 center = this.freeEggPos.method_46558();
            this.getPassengerOvomorphs().forEach(ovomorph -> {
                this.eggCarryingXenomorph.method_37908().method_43129(null, (class_1297)ovomorph, AVPSoundEvents.ENTITY_OVOMORPH_ROOT.get(), class_3419.field_15251, 1.0f, 1.0f);
                ovomorph.isRooted.set(true);
                ovomorph.method_5848();
                ovomorph.method_5814(center.field_1352, center.field_1351, center.field_1350);
                float randomYaw = this.eggCarryingXenomorph.method_59922().method_43057() * 360.0f;
                ovomorph.method_36456(randomYaw);
                ovomorph.method_5847(randomYaw);
                ovomorph.field_6283 = randomYaw;
                ovomorph.field_5982 = randomYaw;
                ovomorph.field_6259 = randomYaw;
                ovomorph.field_6220 = randomYaw;
            });
        }
    }

    public void method_6270() {
        super.method_6270();
        this.failedEggSpots.clear();
        this.freeEggPos = null;
        this.pathToFreeEggPos = null;
    }

    private boolean isUnableToMoveOvomorph() {
        return this.eggCarryingXenomorph.method_5968() != null || !this.isCarryingOvomorph();
    }

    private boolean isCarryingOvomorph() {
        return !this.getPassengerOvomorphs().isEmpty();
    }

    private List<Ovomorph> getPassengerOvomorphs() {
        return this.eggCarryingXenomorph.method_5685().stream().filter(passenger -> passenger instanceof Ovomorph).map(passenger -> (Ovomorph)passenger).toList();
    }

    private Optional<class_2338> findFreeEggSpot(class_1937 level, class_2338 center, Predicate<class_2338> isWalkable) {
        boolean centerIsOdd = (center.method_10263() & 1) != 0 && (center.method_10260() & 1) != 0;
        Optional<class_2338> result = this.tryFindWithParity(level, center, isWalkable, centerIsOdd);
        if (result.isEmpty()) {
            result = this.tryFindWithParity(level, center, isWalkable, !centerIsOdd);
        }
        return result;
    }

    private Optional<class_2338> tryFindWithParity(class_1937 level, class_2338 center, Predicate<class_2338> isWalkable, boolean useOdd) {
        int baseX = (center.method_10263() & 0xFFFFFFFE) + (useOdd ? 1 : 0);
        int baseZ = (center.method_10260() & 0xFFFFFFFE) + (useOdd ? 1 : 0);
        class_2338 gridAlignedCenter = new class_2338(baseX, center.method_10264(), baseZ);
        ArrayList<class_2338> viable = new ArrayList<class_2338>();
        for (class_2338 offset : EGG_GRID_POS_OFFSETS) {
            class_2338 pos2 = gridAlignedCenter.method_10081((class_2382)offset);
            if ((pos2.method_10263() & 1) == 0 == useOdd || (pos2.method_10260() & 1) == 0 == useOdd) continue;
            int verticalSearchRange = 4;
            for (int dy = -4; dy <= 4; ++dy) {
                class_2338 below;
                class_2338 adjustedPos = pos2.method_10086(dy);
                if (this.failedEggSpots.contains(adjustedPos) || !isWalkable.test(below = adjustedPos.method_10074())) continue;
                class_2680 state = level.method_8320(adjustedPos);
                class_2680 aboveState = level.method_8320(adjustedPos.method_10084());
                if (!state.method_26215() && !state.method_45474() || !aboveState.method_26215() && !aboveState.method_45474() || !level.method_8335(null, new class_238(adjustedPos)).isEmpty()) continue;
                viable.add(adjustedPos.method_10062());
            }
        }
        viable.sort(Comparator.comparingDouble(pos -> pos.method_10262((class_2382)gridAlignedCenter)));
        for (int i = 0; i < Math.min(viable.size(), 5); ++i) {
            class_2338 pos3 = (class_2338)viable.get(i);
            class_11 path = this.eggCarryingXenomorph.method_5942().method_6348(pos3, 0);
            if (path != null && path.method_21655()) {
                return Optional.of(pos3);
            }
            this.failedEggSpots.add(pos3);
        }
        return Optional.empty();
    }

    private static List<class_2338> generateSpiralOffsets(int maxDist) {
        int step = 2;
        ArrayList<class_2338> offsets = new ArrayList<class_2338>();
        for (int dist = 0; dist <= maxDist; dist += step) {
            for (int dx = -dist; dx <= dist; dx += step) {
                int dz = dist - Math.abs(dx);
                if ((dz & 1) != 0) continue;
                offsets.add(new class_2338(dx, 0, dz));
                if (dz == 0) continue;
                offsets.add(new class_2338(dx, 0, -dz));
            }
        }
        return offsets;
    }
}

