/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.block.entity.resin.node.behavior;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.block.entity.resin.node.ChargeCursor;
import com.alien.common.gameplay.block.entity.resin.node.ResinSpreader;
import com.alien.common.gameplay.block.entity.resin.node.behavior.VeinSpreadBehavior;
import com.alien.common.gameplay.block.resin.vein.ResinVeinBlock;
import com.alien.common.gameplay.block.resin.vein.ResinVeinRegrowUtil;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.avp.common.registry.AVPDeferredHolder;
import java.util.Collection;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5819;
import net.minecraft.class_7118;
import org.jetbrains.annotations.Nullable;

public class ResinVeinSpreadBehavior
implements VeinSpreadBehavior {
    public static final ResinVeinSpreadBehavior INSTANCE = new ResinVeinSpreadBehavior();

    private ResinVeinSpreadBehavior() {
    }

    @Override
    public boolean attemptSpreadVein(class_2338 nodePos, class_1936 levelAccessor, class_2338 blockPos, class_2680 blockState, @Nullable Collection<class_2350> facings) {
        class_2248 nodeBlock = levelAccessor.method_8320(nodePos).method_26204();
        ResinVeinBlock resinVeinBlock = (ResinVeinBlock)AlienVariantTypes.getFor(nodeBlock).map(AlienVariantType::resinVein).map(AVPDeferredHolder::get).unwrapOr(null);
        if (resinVeinBlock == null) {
            return false;
        }
        if (facings == null) {
            class_7118 spreader = resinVeinBlock.getSameSpaceSpreader();
            return spreader.method_41452(levelAccessor.method_8320(blockPos), levelAccessor, blockPos, false) > 0L;
        }
        if (!facings.isEmpty()) {
            return this.isAirOrWater(blockState) && ResinVeinRegrowUtil.regrow(resinVeinBlock.method_9564(), levelAccessor, blockPos, blockState, facings);
        }
        return VeinSpreadBehavior.super.attemptSpreadVein(nodePos, levelAccessor, blockPos, blockState, facings);
    }

    @Override
    public int attemptUseCharge(ChargeCursor chargeCursor, class_1936 levelAccessor, class_2338 nodePos, class_5819 randomSource, ResinSpreader resinSpreader) {
        return chargeCursor.getDecayDelay() > 0 ? chargeCursor.getCharge() : 0;
    }

    @Override
    public int updateDecayDelay(int decayDelay) {
        return Math.max(decayDelay - 1, 0);
    }

    private boolean isAirOrWater(class_2680 blockState) {
        return blockState.method_26215() || blockState.method_26227().method_39360((class_3611)class_3612.field_15910);
    }
}

