/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.block.entity.resin.vent;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.hive.Hive;
import com.alien.common.gameplay.level.gameevent.listener.CryForHelpListener;
import com.alien.common.gameplay.level.saveddata.HiveLevelData;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.avp.common.registry.init.AVPBlockEntityTypes;
import com.just.core.functional.option.Option;
import com.lib.common.data.Cooldown;
import java.time.Duration;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_5707;
import net.minecraft.class_5714;
import net.minecraft.class_5716;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResinVentBlockEntity
extends class_2586
implements class_5714.class_8513<CryForHelpListener> {
    private final Cooldown alienSpawnCooldown;
    private final CryForHelpListener cryForHelpListener;
    @Nullable
    private Hive hive;

    public ResinVentBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(AVPBlockEntityTypes.RESIN_VENT.get(), blockPos, blockState);
        class_5707 positionSource = new class_5707(blockPos);
        this.alienSpawnCooldown = Cooldown.withCooldownTime("spawnAlienCooldown", Duration.ofSeconds(3L));
        this.cryForHelpListener = new CryForHelpListener((class_5716)positionSource);
    }

    @Nullable
    public Hive getHive() {
        return this.hive;
    }

    public Cooldown getAlienSpawnCooldown() {
        return this.alienSpawnCooldown;
    }

    public void setHive(@Nullable Hive hive) {
        this.hive = hive;
    }

    public static void serverTick(class_1937 level, class_2338 ventPos, class_2680 blockState, ResinVentBlockEntity resinVentBlockEntity) {
        resinVentBlockEntity.getAlienSpawnCooldown().tick();
        Hive hive = resinVentBlockEntity.getHive();
        if (hive != null) {
            if (!hive.isAlive() || !hive.getSpaceManager().isBlockPosWithinHive(ventPos)) {
                resinVentBlockEntity.setHive(null);
                hive.getVentManager().removeVent(ventPos);
                return;
            }
            hive.getVentManager().addVent(ventPos);
            return;
        }
        if (level.method_8510() % 20L == 0L) {
            Option<AlienVariantType> ventVariantTypeOption = AlienVariantTypes.getFor(blockState);
            if (ventVariantTypeOption.isNone()) {
                return;
            }
            AlienVariant ventAlienVariant = ((AlienVariantType)ventVariantTypeOption.unwrap()).variant();
            HiveLevelData.getOrCreate(level).andThen(hiveLevelData -> hiveLevelData.findNearestHive(ventPos, nearestHive -> Objects.equals((Object)nearestHive.getVariant(), (Object)ventAlienVariant))).filter(nearestHive -> nearestHive.isAlive() && nearestHive.getSpaceManager().isBlockPosWithinHive(ventPos)).ifSome(resinVentBlockEntity::setHive);
        }
    }

    @NotNull
    public CryForHelpListener getListener() {
        return this.cryForHelpListener;
    }
}

