/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.hive.Hive;
import com.alien.common.gameplay.hive.HiveSpaceManager;
import com.alien.common.gameplay.level.saveddata.HiveLevelData;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.just.core.functional.option.Option;
import java.util.Objects;
import net.minecraft.class_1299;
import net.minecraft.class_1317;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_5819;

public class AlienSpawning {
    private static final class_1317.class_4306<Alien> PREDICATE = (entityType, serverLevelAccessor, mobSpawnType, blockPos, randomSource) -> {
        class_2680 belowState = serverLevelAccessor.method_8320(blockPos.method_10074());
        Option alienVariantTypeOption = AlienVariantTypes.getFor(entityType).map(AlienVariantType::resinBlockTag);
        boolean isValidResinPos = alienVariantTypeOption.isSomeAnd(arg_0 -> ((class_2680)belowState).method_26164(arg_0));
        return isValidResinPos && AlienSpawning.checkSpawnRules((class_1299<? extends class_1588>)entityType, serverLevelAccessor, mobSpawnType, blockPos, randomSource);
    };

    public static <T extends Alien> class_1317.class_4306<T> getTypedPredicate() {
        return PREDICATE;
    }

    public static boolean checkSpawnRules(class_1299<? extends class_1588> entityType, class_5425 serverLevelAccessor, class_3730 mobSpawnType, class_2338 blockPos, class_5819 randomSource) {
        return class_1588.method_20680(entityType, (class_5425)serverLevelAccessor, (class_3730)mobSpawnType, (class_2338)blockPos, (class_5819)randomSource) && AlienSpawning.canSpawnWithinNearestHive(entityType, serverLevelAccessor, blockPos);
    }

    private static boolean canSpawnWithinNearestHive(class_1299<? extends class_1588> entityType, class_5425 serverLevelAccessor, class_2338 blockPos) {
        Option<AlienVariantType> alienVariantTypeOption = AlienVariantTypes.getFor(entityType);
        return HiveLevelData.getOrCreate((class_1937)serverLevelAccessor.method_8410()).andThen(hiveLevelData -> hiveLevelData.findNearestHive(blockPos, hive -> alienVariantTypeOption.isSomeAnd(alienVariantType -> Objects.equals((Object)hive.getVariant(), (Object)alienVariantType.variant())))).isSomeAnd(nearestHive -> nearestHive.isAlive() && AlienSpawning.canEntityTypeSpawnWithinHiveLayer(nearestHive, entityType, blockPos) && nearestHive.getReserveManager().canSpawn(entityType));
    }

    private static boolean canEntityTypeSpawnWithinHiveLayer(Hive nearestHive, class_1299<? extends class_1588> entityType, class_2338 blockPos) {
        HiveSpaceManager.HiveLayer layer = nearestHive.getSpaceManager().getHiveLayerOrNull(blockPos);
        if (layer == null) {
            return false;
        }
        return switch (layer) {
            default -> throw new MatchException(null, null);
            case HiveSpaceManager.HiveLayer.EDGE, HiveSpaceManager.HiveLayer.LEASH, HiveSpaceManager.HiveLayer.BUFFER -> false;
            case HiveSpaceManager.HiveLayer.WARRIOR -> entityType.method_20210(AVPEntityTypeTags.SPAWNS_IN_HIVE_WARRIOR_LAYER);
            case HiveSpaceManager.HiveLayer.DRONE -> entityType.method_20210(AVPEntityTypeTags.SPAWNS_IN_HIVE_DRONE_LAYER);
            case HiveSpaceManager.HiveLayer.PRAETORIAN -> entityType.method_20210(AVPEntityTypeTags.SPAWNS_IN_HIVE_PRAETORIAN_LAYER);
            case HiveSpaceManager.HiveLayer.CENTER -> entityType.method_20210(AVPEntityTypeTags.SPAWNS_IN_HIVE_QUEEN_LAYER);
        };
    }
}

