/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.adolescent;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.GrowthManager;
import com.alien.common.gameplay.entity.living.alien.adolescent.AdolescentAnimationDispatcher;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.registry.init.AlienEntityTypes;
import com.alien.common.util.AlienPredicates;
import com.alien.common.util.XenomorphGrowthUtil;
import com.avp.AVP;
import com.avp.common.registry.init.AVPDataKeys;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.util.AVPPredicates;
import com.lib.common.network.DataAccessor;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1338;
import net.minecraft.class_1352;
import net.minecraft.class_1394;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_5132;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Adolescent
extends Alien {
    private static final String NBT_HAS_DORSAL_TUBES = "hasDorsalTubes";
    public final DataAccessor<Boolean> hasDorsalTubes = new DataAccessor<Boolean>(this, AVPDataKeys.ADOLESCENT_HAS_DORSAL_TUBES);
    private final AdolescentAnimationDispatcher animationDispatcher = new AdolescentAnimationDispatcher(this);
    private final GrowthManager growthManager = new GrowthManager(this, XenomorphGrowthUtil.GROW_UP_CALLBACK).setGrowOverTime(true);

    public static class_5132.class_5133 createAdolescentAttributes() {
        return Adolescent.applyFrom(AVP.config.statsConfigs.ADOLESCENT_STATS, class_1588.method_26918());
    }

    public Adolescent(class_1299<? extends Adolescent> entityType, class_1937 level) {
        super(entityType, level);
        this.config = AVP.config.statsConfigs.ADOLESCENT_STATS;
    }

    @Override
    @Nullable
    public class_1299<? extends Alien> getTypeForVariant(AlienVariant alienVariant) {
        return Adolescent.getType(alienVariant, this.isRoyal());
    }

    protected void method_5959() {
        this.field_6201.method_6277(3, (class_1352)new class_1338((class_1314)this, class_1309.class, 8.0f, 1.0, 1.2, entity -> {
            boolean bl;
            if (entity instanceof Alien) {
                Alien alien = (Alien)entity;
                bl = AlienPredicates.areAliensEnemies(this, alien);
            } else {
                bl = !AVPPredicates.IS_IMMORTAL.test((class_1309)entity);
            }
            return bl;
        }));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 0.5));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.growthManager.tick();
        if (!this.method_37908().field_9236) {
            this.getHostType().ifSome(hostType -> this.hasDorsalTubes.set(!hostType.method_20210(AVPEntityTypeTags.RUNNER_HOSTS)));
        }
    }

    @Override
    protected float getHealthRegenPerSecond() {
        return AVP.config.statsConfigs.ADOLESCENT_STATS.healthRegenPerSecond;
    }

    @Override
    public void method_5749(@NotNull class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.growthManager.load(compoundTag);
        if (compoundTag.method_10545(NBT_HAS_DORSAL_TUBES)) {
            this.hasDorsalTubes.set(compoundTag.method_10577(NBT_HAS_DORSAL_TUBES));
        }
    }

    @Override
    public void method_5652(@NotNull class_2487 compoundTag) {
        super.method_5652(compoundTag);
        this.growthManager.save(compoundTag);
        compoundTag.method_10556(NBT_HAS_DORSAL_TUBES, this.hasDorsalTubes.get().booleanValue());
    }

    @Override
    public Integer getMaxJellyToGrowth() {
        return 1;
    }

    public AdolescentAnimationDispatcher getAnimationDispatcher() {
        return this.animationDispatcher;
    }

    @Nullable
    public static class_1299<? extends Alien> getType(AlienVariant alienVariant, boolean isRoyal) {
        if (isRoyal) {
            return switch (alienVariant) {
                default -> throw new MatchException(null, null);
                case AlienVariant.NORMAL -> AlienEntityTypes.ROYAL_ADOLESCENT.get();
                case AlienVariant.NETHER -> AlienEntityTypes.ROYAL_NETHER_ADOLESCENT.get();
                case AlienVariant.ABERRANT -> AlienEntityTypes.ROYAL_ABERRANT_ADOLESCENT.get();
                case AlienVariant.IRRADIATED -> null;
            };
        }
        return switch (alienVariant) {
            default -> throw new MatchException(null, null);
            case AlienVariant.NORMAL -> AlienEntityTypes.ADOLESCENT.get();
            case AlienVariant.NETHER -> AlienEntityTypes.NETHER_ADOLESCENT.get();
            case AlienVariant.ABERRANT -> AlienEntityTypes.ABERRANT_ADOLESCENT.get();
            case AlienVariant.IRRADIATED -> null;
        };
    }
}

