/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.ovomorph;

import com.alien.common.gameplay.entity.living.alien.ovomorph.Ovomorph;
import com.avp.common.registry.init.AVPDataKeys;
import com.avp.common.util.AVPPredicates;
import com.lib.common.gameplay.entity.manager.VibrationSystemManager;
import com.lib.common.network.DataAccessor;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_7269;

public class HatchDesireManager {
    private static final int MAXIMUM_DESIRE_TO_HATCH = 100;
    private final Ovomorph ovomorph;
    private final DataAccessor<Integer> desireToHatch;
    private class_7269 lastVibrationInfo;

    public HatchDesireManager(Ovomorph ovomorph) {
        this.ovomorph = ovomorph;
        this.desireToHatch = new DataAccessor<Integer>(ovomorph, AVPDataKeys.OVOMORPH_DESIRE_TO_HATCH);
    }

    public void tick() {
        this.handleVibration();
        if (this.ovomorph.field_6012 % 20 == 0) {
            this.addDesire(-1);
        }
        if (this.ovomorph.getHatchManager().isHatched()) {
            this.desireToHatch.reset();
        }
    }

    private void handleVibration() {
        VibrationSystemManager vibrationSystemManager = this.ovomorph.getVibrationSystemManager();
        class_7269 vibrationInfo = vibrationSystemManager.method_51298().method_51394();
        if (vibrationInfo != null && !Objects.equals(vibrationInfo, this.lastVibrationInfo)) {
            int radius = vibrationSystemManager.method_51299().method_49797();
            class_1297 sourceEntity = vibrationInfo.comp_661();
            if (sourceEntity != null && AVPPredicates.isFreeHost(this.ovomorph, sourceEntity) && this.ovomorph.method_5985().method_6369(sourceEntity)) {
                int baseDesire = (int)Math.abs((float)radius - vibrationInfo.comp_658()) * 2;
                class_1937 level = this.ovomorph.method_37908();
                class_2338 blockPos = this.ovomorph.method_24515();
                int brightness = level.method_22335(blockPos, 0);
                double bonusFactor = 5.0;
                double clampedBrightness = Math.clamp((double)brightness, bonusFactor, 15.0);
                int brightnessBonus = (int)(clampedBrightness / bonusFactor);
                this.addDesire(baseDesire * brightnessBonus);
            }
            this.lastVibrationInfo = vibrationInfo;
        }
    }

    public boolean wantsToHatch() {
        return this.desireToHatch.get() == 100;
    }

    private void addDesire(int desireAmount) {
        this.desireToHatch.set(Math.clamp((long)(this.desireToHatch.get() + desireAmount), 0, 100));
    }
}

