/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.xenomorph;

import com.alien.common.gameplay.entity.living.alien.ovomorph.Ovomorph;
import com.alien.common.gameplay.entity.living.alien.xenomorph.EggPickupRequestListener;
import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5714;
import net.minecraft.class_5715;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EggPickupManager
implements class_5714.class_8513<EggPickupRequestListener> {
    private final class_5715<EggPickupRequestListener> dynamicEggPickupRequestListener;
    private final EggPickupRequestListener eggPickupRequestListener;
    private final Xenomorph xenomorph;
    private Ovomorph targetOvomorph;

    public EggPickupManager(Xenomorph xenomorph) {
        this.eggPickupRequestListener = new EggPickupRequestListener((class_1297)xenomorph, this::acknowledgePickupRequest);
        this.dynamicEggPickupRequestListener = new class_5715((class_5714)this.eggPickupRequestListener);
        this.xenomorph = xenomorph;
    }

    @NotNull
    public EggPickupRequestListener getListener() {
        return this.eggPickupRequestListener;
    }

    public void updateDynamicGameEventListener(@NotNull BiConsumer<class_5715<?>, class_3218> biConsumer) {
        class_1937 class_19372 = this.xenomorph.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            biConsumer.accept(this.dynamicEggPickupRequestListener, serverLevel);
        }
    }

    public void tick() {
        if (this.xenomorph.method_37908().field_9236) {
            return;
        }
        this.getPassengerOvomorphs().stream().filter(ovomorph -> this.xenomorph.method_5968() != null || !ovomorph.canBeHeld()).forEach(class_1297::method_5848);
        if (this.xenomorph.method_5968() != null || this.targetOvomorph != null && !this.targetOvomorph.canBeHeld()) {
            this.setTargetOvomorph(null);
        }
    }

    private List<Ovomorph> getPassengerOvomorphs() {
        return this.xenomorph.method_5685().stream().filter(passenger -> passenger.method_5864().method_20210(AVPEntityTypeTags.OVOMORPHS)).map(entity -> (Ovomorph)entity).toList();
    }

    @Nullable
    public Ovomorph getTargetOvomorphOrNull() {
        return this.targetOvomorph;
    }

    public void setTargetOvomorph(Ovomorph targetOvomorph) {
        if (targetOvomorph == null) {
            if (this.targetOvomorph != null) {
                this.targetOvomorph.pickupRequestAcknowledged = false;
            }
        } else {
            targetOvomorph.pickupRequestAcknowledged = true;
        }
        this.targetOvomorph = targetOvomorph;
    }

    private void acknowledgePickupRequest(Ovomorph ovomorph) {
        if (this.targetOvomorph != null || !this.getPassengerOvomorphs().isEmpty() || this.xenomorph.method_5942().method_6349((class_1297)ovomorph, 0) == null) {
            return;
        }
        ovomorph.pickupRequestAcknowledged = true;
        this.setTargetOvomorph(ovomorph);
    }
}

