/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.xenomorph;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.GrowthManager;
import com.alien.common.gameplay.entity.living.alien.ResinManager;
import com.alien.common.gameplay.entity.living.alien.xenomorph.XenomorphNavigationManager;
import com.alien.common.model.resin.ResinData;
import com.alien.common.model.resin.ResinProducer;
import com.alien.common.util.AlienPredicates;
import com.alien.common.util.XenomorphGrowthUtil;
import com.avp.common.gameplay.ai.goal.DigToTargetGoal;
import com.avp.common.gameplay.ai.goal.StrollAroundInWaterGoal;
import com.avp.common.gameplay.ai.goal.XenoFloatGoal;
import com.avp.common.registry.init.AVPDataKeys;
import com.avp.common.registry.init.AVPSoundEvents;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.lib.common.gameplay.entity.manager.CrawlingManager;
import com.lib.common.network.DataAccessor;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1690;
import net.minecraft.class_1695;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3486;
import net.minecraft.class_3611;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4538;
import net.minecraft.class_5715;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Xenomorph
extends Alien
implements ResinProducer {
    public final DataAccessor<Boolean> isCrawling = new DataAccessor<Boolean>(this, AVPDataKeys.XENOMORPH_IS_CRAWLING);
    protected final CrawlingManager crawlingManager = new CrawlingManager((class_1314)this, this.isCrawling);
    private final XenomorphNavigationManager navigationManager;
    private final GrowthManager growthManager = new GrowthManager(this, XenomorphGrowthUtil.GROW_UP_CALLBACK).setGrowOverTime(false);
    private final ResinManager resinManager;
    private boolean wasUnderwaterLastTick = false;

    public Xenomorph(class_1299<? extends Xenomorph> entityType, class_1937 level) {
        super(entityType, level);
        this.navigationManager = new XenomorphNavigationManager(this, this.field_6207);
        this.resinManager = new ResinManager(this, this.createResinData());
        this.isCrawling.onChange($ -> this.method_18382());
    }

    protected double getPursuitSpeedModifier() {
        return 1.1;
    }

    protected int getAttackDelayInTicks() {
        return 5;
    }

    protected boolean canTargetInitially(class_1309 target) {
        return true;
    }

    @Nullable
    protected abstract ResinData createResinData();

    public abstract void runAttackAnimations();

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new XenoFloatGoal((class_1308)this));
        this.addDigToTargetGoal();
        this.field_6201.method_6277(7, (class_1352)new StrollAroundInWaterGoal((class_1314)this, 0.5));
        this.field_6201.method_6277(7, (class_1352)new class_1394((class_1314)this, 0.5));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[]{Xenomorph.class}));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1309.class, false, target -> AlienPredicates.canTarget(this, target) && this.canTargetInitially((class_1309)target)));
    }

    protected void addDigToTargetGoal() {
        this.field_6201.method_6277(5, (class_1352)new DigToTargetGoal((class_1308)this, 32.0, 2, () -> true));
    }

    @Override
    public void method_5773() {
        class_1309 target;
        super.method_5773();
        this.crawlingManager.tick();
        this.growthManager.tick();
        this.resinManager.tick();
        this.updateDimensionsBasedOnWaterState();
        if (!this.method_37908().field_9236 && (target = this.method_5968()) != null && !AlienPredicates.canContinueTargeting(this, target)) {
            this.method_5980(null);
        }
    }

    private void updateDimensionsBasedOnWaterState() {
        if (this.wasUnderwaterLastTick != this.method_5869()) {
            this.method_18382();
        }
        this.wasUnderwaterLastTick = this.method_5869();
    }

    public void method_6091(@NotNull class_243 vec3) {
        if (this.method_5787() && this.method_5869()) {
            this.method_5724(0.01f, vec3);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.9));
        } else {
            super.method_6091(vec3);
        }
    }

    public void method_5790() {
        if (!this.method_37908().field_9236) {
            if (this.method_6034() && this.method_5869()) {
                this.navigationManager.switchToWater(this, 4, this.field_6201);
                this.method_5796(true);
            } else {
                this.navigationManager.switchToGround(this, 4, this.field_6201);
                this.method_5796(false);
            }
        }
    }

    public boolean method_5873(@NotNull class_1297 entity, boolean force) {
        if (entity instanceof class_1690 || entity instanceof class_1695) {
            return false;
        }
        return super.method_5873(entity, force);
    }

    @NotNull
    public class_4048 method_55694(@NotNull class_4050 pose) {
        class_4048 defaultDimensions = this.method_5864().method_18386();
        boolean shouldBeSmall = this.crawlingManager.isCrawling() || this.method_5869();
        return defaultDimensions.method_19539(1.0f, shouldBeSmall ? 0.4f : 1.0f);
    }

    @Override
    public void method_42147(@NotNull BiConsumer<class_5715<?>, class_3218> biConsumer) {
        super.method_42147(biConsumer);
        this.resinManager.updateDynamicGameEventListener(biConsumer);
    }

    public boolean method_42149() {
        return true;
    }

    public float method_6144(@NotNull class_2338 blockPos, @NotNull class_4538 levelReader) {
        return 0.0f;
    }

    public boolean method_5692(@NotNull class_6862<class_3611> tagKey, double d) {
        double modifier = d;
        if (Objects.equals(tagKey, class_3486.field_15517)) {
            modifier = 0.0;
        }
        if (this.isNetherAfflicted() && Objects.equals(tagKey, class_3486.field_15518)) {
            modifier = 0.0;
        }
        return super.method_5692(tagKey, modifier);
    }

    @Override
    public void method_5980(@Nullable class_1309 livingEntity) {
        if (livingEntity != null && !livingEntity.equals((Object)this.method_5968()) && this.field_6191 > this.method_5970()) {
            this.method_5783(AVPSoundEvents.ENTITY_XENOMORPH_HISS.get(), this.method_6107(), (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
        }
        super.method_5980(livingEntity);
    }

    public boolean method_18395(@NotNull class_1309 target) {
        return super.method_18395(target) && AlienPredicates.canContinueTargeting(this, target);
    }

    protected void method_6087(class_1297 entity) {
        if (!(entity.method_5864().method_20210(AVPEntityTypeTags.FACEHUGGERS) || entity.method_5864().method_20210(AVPEntityTypeTags.CHESTBURSTERS) || entity.method_5864().method_20210(AVPEntityTypeTags.ADOLESCENTS))) {
            super.method_6087(entity);
        }
    }

    public int method_5970() {
        return 120;
    }

    @Nullable
    protected class_3414 method_5994() {
        return this.method_5968() != null ? AVPSoundEvents.ENTITY_XENOMORPH_HISS.get() : AVPSoundEvents.ENTITY_XENOMORPH_IDLE.get();
    }

    @NotNull
    protected class_3414 method_6002() {
        return AVPSoundEvents.ENTITY_XENOMORPH_DEATH.get();
    }

    @NotNull
    protected class_3414 method_6011(@NotNull class_1282 damageSource) {
        return AVPSoundEvents.ENTITY_XENOMORPH_HURT.get();
    }

    @Override
    public void method_5749(@NotNull class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.crawlingManager.load(compoundTag);
        this.growthManager.load(compoundTag);
        this.resinManager.load(compoundTag);
    }

    @Override
    public void method_5652(@NotNull class_2487 compoundTag) {
        super.method_5652(compoundTag);
        this.crawlingManager.save(compoundTag);
        this.growthManager.save(compoundTag);
        this.resinManager.save(compoundTag);
    }

    public GrowthManager getGrowthManager() {
        return this.growthManager;
    }

    @Override
    public ResinManager getResinManager() {
        return this.resinManager;
    }

    public CrawlingManager getCrawlingManager() {
        return this.crawlingManager;
    }

    public void setMoveControl(class_1335 moveControl) {
        this.field_6207 = moveControl;
    }

    public void setNavigation(class_1408 navigation) {
        this.field_6189 = navigation;
    }
}

